/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.MapRequestHeaderGatewayFilterFactory;
import org.springframework.test.context.ActiveProfiles;

public class DisableBuiltInFiltersTests {

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.filter.add-request-header.enabled=false", "spring.cloud.gateway.filter.map-request-header.enabled=false", "spring.cloud.gateway.filter.add-request-headers-if-not-present.enabled=false", "spring.cloud.gateway.filter.add-request-parameter.enabled=false", "spring.cloud.gateway.filter.add-response-header.enabled=false", "spring.cloud.gateway.filter.json-to-grpc.enabled=false", "spring.cloud.gateway.filter.modify-request-body.enabled=false", "spring.cloud.gateway.filter.local-response-cache.enabled=false", "spring.cloud.gateway.filter.dedupe-response-header.enabled=false", "spring.cloud.gateway.filter.modify-response-body.enabled=false", "spring.cloud.gateway.filter.prefix-path.enabled=false", "spring.cloud.gateway.filter.preserve-host-header.enabled=false", "spring.cloud.gateway.filter.redirect-to.enabled=false", "spring.cloud.gateway.filter.remove-json-attributes-response-body.enabled=false", "spring.cloud.gateway.filter.remove-request-header.enabled=false", "spring.cloud.gateway.filter.remove-request-parameter.enabled=false", "spring.cloud.gateway.filter.remove-response-header.enabled=false", "spring.cloud.gateway.filter.request-rate-limiter.enabled=false", "spring.cloud.gateway.filter.rewrite-path.enabled=false", "spring.cloud.gateway.filter.retry.enabled=false", "spring.cloud.gateway.filter.set-path.enabled=false", "spring.cloud.gateway.filter.secure-headers.enabled=false", "spring.cloud.gateway.filter.set-request-header.enabled=false", "spring.cloud.gateway.filter.set-request-host-header.enabled=false", "spring.cloud.gateway.filter.set-response-header.enabled=false", "spring.cloud.gateway.filter.rewrite-response-header.enabled=false", "spring.cloud.gateway.filter.rewrite-location-response-header.enabled=false", "spring.cloud.gateway.filter.rewrite-location.enabled=false", "spring.cloud.gateway.filter.set-status.enabled=false", "spring.cloud.gateway.filter.save-session.enabled=false", "spring.cloud.gateway.filter.strip-prefix.enabled=false", "spring.cloud.gateway.filter.request-header-to-request-uri.enabled=false", "spring.cloud.gateway.filter.request-size.enabled=false", "spring.cloud.gateway.filter.request-header-size.enabled=false", "spring.cloud.gateway.filter.circuit-breaker.enabled=false", "spring.cloud.gateway.filter.token-relay.enabled=false", "spring.cloud.gateway.filter.cache-request-body.enabled=false", "spring.cloud.gateway.filter.fallback-headers.enabled=false"})
    @ActiveProfiles(value={"disable-components"})
    public class DisableAllFiltersByProperty {
        @Autowired(required=false)
        private List<GatewayFilterFactory<?>> gatewayFilters;

        @Test
        public void shouldDisableAllBuiltInFilters() {
            Assertions.assertThat(this.gatewayFilters).isNull();
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.filter.add-request-header.enabled=false", "spring.cloud.gateway.filter.map-request-header.enabled=false"})
    @ActiveProfiles(value={"disable-components"})
    public class DisableSpecificsFiltersByProperty {
        @Autowired
        private List<GatewayFilterFactory<?>> gatewayFilters;

        @Test
        public void shouldInjectOnlyEnabledBuiltInFilters() {
            Assertions.assertThat(this.gatewayFilters).hasSizeGreaterThan(0);
            Assertions.assertThat(this.gatewayFilters).allSatisfy(filter -> Assertions.assertThat((Object)filter).isNotInstanceOfAny(new Class[]{AddRequestHeaderGatewayFilterFactory.class, MapRequestHeaderGatewayFilterFactory.class}));
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class})
    public class FilterDefault {
        @Autowired
        private List<GatewayFilterFactory<?>> gatewayFilters;

        @Test
        public void shouldInjectBuiltInFilters() {
            Assertions.assertThat(this.gatewayFilters).hasSizeGreaterThanOrEqualTo(31);
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    protected static class Config {
        protected Config() {
        }
    }
}

