/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.cors;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(profiles={"cors-per-route-config"})
public class CorsPerRouteTests
extends BaseWebClientTests {
    @Test
    public void testPreFlightCorsRequest() {
        this.testClient.options().uri("/abc", new Object[0]).header("Origin", new String[]{"domain.com"}).header("Access-Control-Request-Method", new String[]{"GET"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Assertions.assertThat((Map)((Map)result.getResponseBody())).isNull();
            Assertions.assertThat((Object)result.getStatus()).isEqualTo((Object)HttpStatus.OK);
            HttpHeaders responseHeaders = result.getResponseHeaders();
            ((AbstractStringAssert)Assertions.assertThat((String)responseHeaders.getAccessControlAllowOrigin()).as(this.missingHeader("Access-Control-Allow-Origin"), new Object[0])).isEqualTo("domain.com");
            ((ListAssert)Assertions.assertThat((List)responseHeaders.getAccessControlAllowMethods()).as(this.missingHeader("Access-Control-Allow-Methods"), new Object[0])).containsExactlyInAnyOrder((Object[])new HttpMethod[]{HttpMethod.GET, HttpMethod.POST});
            ((AbstractLongAssert)Assertions.assertThat((long)responseHeaders.getAccessControlMaxAge()).as(this.missingHeader("Access-Control-Max-Age"), new Object[0])).isEqualTo(30L);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)responseHeaders.getAccessControlAllowCredentials()).as(this.missingHeader("Access-Control-Allow-Credentials"), new Object[0])).isEqualTo(true);
        });
    }

    @Test
    public void testPreFlightCorsRequestJavaConfig() {
        this.testClient.options().uri("/route-test", new Object[0]).header("Origin", new String[]{"another-domain.com"}).header("Host", new String[]{"www.javaconfhost.org"}).header("Access-Control-Request-Method", new String[]{"GET"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Assertions.assertThat((Map)((Map)result.getResponseBody())).isNull();
            Assertions.assertThat((Object)result.getStatus()).isEqualTo((Object)HttpStatus.OK);
            HttpHeaders responseHeaders = result.getResponseHeaders();
            ((AbstractStringAssert)Assertions.assertThat((String)responseHeaders.getAccessControlAllowOrigin()).as(this.missingHeader("Access-Control-Allow-Origin"), new Object[0])).isEqualTo("another-domain.com");
            ((ListAssert)Assertions.assertThat((List)responseHeaders.getAccessControlAllowMethods()).as(this.missingHeader("Access-Control-Allow-Methods"), new Object[0])).containsExactlyInAnyOrder((Object[])new HttpMethod[]{HttpMethod.GET});
            ((AbstractLongAssert)Assertions.assertThat((long)responseHeaders.getAccessControlMaxAge()).as(this.missingHeader("Access-Control-Max-Age"), new Object[0])).isEqualTo(50L);
        });
    }

    @Test
    public void testPreFlightForbiddenCorsRequest() {
        this.testClient.get().uri("/cors", new Object[0]).header("Origin", new String[]{"domain.com"}).header("Access-Control-Request-Method", new String[]{"GET"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Assertions.assertThat((Map)((Map)result.getResponseBody())).isNull();
            Assertions.assertThat((Object)result.getStatus()).isEqualTo((Object)HttpStatus.FORBIDDEN);
        });
    }

    @Test
    public void testCorsValidatedRequest() {
        this.testClient.get().uri("/cors/status/201", new Object[0]).header("Origin", new String[]{"https://test.com"}).exchange().expectBody(String.class).consumeWith(result -> {
            Assertions.assertThat((String)((String)result.getResponseBody())).endsWith((CharSequence)"201");
            Assertions.assertThat((Object)result.getStatus()).isEqualTo((Object)HttpStatus.CREATED);
        });
    }

    private String missingHeader(String accessControlAllowOrigin) {
        return "Missing header value in response: " + accessControlAllowOrigin;
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("cors_route_java_test", r -> r.host(new String[]{"*.javaconfhost.org"}).and().path(new String[]{"/route-test/**"}).filters(f -> f.stripPrefix(1).prefixPath("/httpbin")).metadata(Map.of("cors", Map.of("allowedOrigins", "another-domain.com", "allowedMethods", HttpMethod.GET.name(), "maxAge", 50))).uri(this.uri)).build();
        }
    }
}

