/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.NettyRoutingFilter;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(value={"netty-routing-filter"})
class NettyRoutingFilterCompatibleTests
extends BaseWebClientTests {
    NettyRoutingFilterCompatibleTests() {
    }

    @Test
    void shouldApplyConnectTimeoutPerRoute() {
        Assertions.assertThat((Integer)NettyRoutingFilter.getInteger((Object)"5")).isEqualTo(5);
        Assertions.assertThat((Integer)NettyRoutingFilter.getInteger((Object)5)).isEqualTo(5);
    }

    @Test
    void getLongHandlesStringAndNumber() {
        Assertions.assertThat((Long)NettyRoutingFilter.getLong((Object)"5")).isEqualTo(5L);
        Assertions.assertThat((Long)NettyRoutingFilter.getLong((Object)5)).isEqualTo(5L);
        Assertions.assertThat((Long)NettyRoutingFilter.getLong((Object)50000L)).isEqualTo(50000L);
        Assertions.assertThat((Long)NettyRoutingFilter.getLong(null)).isNull();
        Assertions.assertThatThrownBy(() -> NettyRoutingFilter.getLong((Object)"notanumber")).isInstanceOf(NumberFormatException.class);
    }

    @Test
    void shouldApplyResponseTimeoutPerRoute() {
        this.testClient.get().uri("/route/delay/2", new Object[0]).exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT).expectBody().jsonPath("$.status", new Object[0]).isEqualTo((Object)String.valueOf(HttpStatus.GATEWAY_TIMEOUT.value())).jsonPath("$.message", new Object[0]).isEqualTo((Object)"Response took longer than timeout: PT1S");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    static class TestConfig {
        TestConfig() {
        }
    }
}

