/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.web.util.UriComponentsBuilder;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
class AddResponseHeaderGatewayFilterFactoryTests
extends BaseWebClientTests {
    AddResponseHeaderGatewayFilterFactoryTests() {
    }

    @Test
    void testResposneHeaderFilter() {
        URI uri = UriComponentsBuilder.fromUriString((String)(this.baseUri + "/headers")).build(true).toUri();
        String host = "www.addresponseheader.org";
        String expectedValue = "Bar";
        this.testClient.get().uri(uri).header("Host", new String[]{host}).exchange().expectHeader().valueEquals("X-Request-Foo", new String[]{expectedValue});
    }

    @Test
    void testResposneHeaderFilterJavaDsl() {
        URI uri = UriComponentsBuilder.fromUriString((String)(this.baseUri + "/get")).build(true).toUri();
        String host = "www.addresponseheaderjava.org";
        String expectedValue = "myresponsevalue-www";
        this.testClient.get().uri(uri).header("Host", new String[]{host}).exchange().expectHeader().valueEquals("example", new String[]{expectedValue});
    }

    @Test
    void toStringFormat() {
        AbstractNameValueGatewayFilterFactory.NameValueConfig config = new AbstractNameValueGatewayFilterFactory.NameValueConfig().setName("myname").setValue("myvalue");
        GatewayFilter filter = new AddResponseHeaderGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"})).contains(new CharSequence[]{"myvalue"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        TestConfig() {
        }

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("add_response_header_java_test", r -> r.path(new String[]{"/get"}).and().host(new String[]{"{sub}.addresponseheaderjava.org"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("example", "myresponsevalue-{sub}")).uri(this.uri)).build();
        }
    }
}

