/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.CacheRequestBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class CacheRequestBodyGatewayFilterFactoryTests
extends BaseWebClientTests {
    private static final String BODY_VALUE = "here is request body";
    private static final String BODY_EMPTY = "";
    private static final String BODY_CACHED_EXISTS = "BODY_CACHED_EXISTS";

    @Test
    public void cacheRequestBodyWorks() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.cacherequestbody.org"})).bodyValue((Object)BODY_VALUE).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map response = (Map)result.getResponseBody();
            Assertions.assertThat((Map)response).isNotNull();
            String responseBody = (String)response.get("data");
            Assertions.assertThat((String)responseBody).isEqualTo(BODY_VALUE);
        });
    }

    @Test
    public void cacheRequestBodyEmpty() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.cacherequestbodyempty.org"})).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map response = (Map)result.getResponseBody();
            Assertions.assertThat((Map)response).isNotNull();
            Assertions.assertThat(response.get("data")).isNull();
        });
    }

    @Test
    public void cacheRequestBodyExists() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.cacherequestbodyexists.org"})).exchange().expectStatus().isOk();
    }

    @Test
    public void toStringFormat() {
        CacheRequestBodyGatewayFilterFactory.Config config = new CacheRequestBodyGatewayFilterFactory.Config();
        config.setBodyClass(String.class);
        GatewayFilter filter = new CacheRequestBodyGatewayFilterFactory().apply(config);
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"String"});
    }

    private static class CheckCachedRequestBodyReleasedGatewayFilter
    implements GatewayFilter {
        CheckCachedRequestBodyReleasedGatewayFilter() {
        }

        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            return chain.filter(exchange).doAfterTerminate(() -> {
                PooledDataBuffer dataBuffer;
                Object o = exchange.getAttributes().get("cachedOriginalRequestBodyBackup");
                if (o instanceof PooledDataBuffer && (dataBuffer = (PooledDataBuffer)o).isAllocated()) {
                    exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                    Assertions.fail((String)"DataBuffer is not released");
                }
            });
        }
    }

    private static class SetExchangeCachedRequestBodyGatewayFilter
    implements GatewayFilter {
        private String bodyToSetCache;

        SetExchangeCachedRequestBodyGatewayFilter(String toSet) {
            this.bodyToSetCache = toSet;
        }

        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            exchange.getAttributes().put("cachedRequestBody", this.bodyToSetCache);
            return chain.filter(exchange);
        }
    }

    private static class AssertCachedRequestBodyGatewayFilter
    implements GatewayFilter {
        private boolean exceptNullBody;
        private String bodyExcepted;

        AssertCachedRequestBodyGatewayFilter(String body) {
            this.exceptNullBody = !StringUtils.hasText((String)body);
            this.bodyExcepted = body;
        }

        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            String body = (String)exchange.getAttribute("cachedRequestBody");
            if (this.exceptNullBody) {
                Assertions.assertThat((String)body).isNull();
            } else {
                Assertions.assertThat((String)body).isEqualTo(this.bodyExcepted);
            }
            return chain.filter(exchange);
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("cache_request_body_java_test", r -> r.path(new String[]{"/post"}).and().host(new String[]{"**.cacherequestbody.org"}).filters(f -> f.prefixPath("/httpbin").cacheRequestBody(String.class).filter((GatewayFilter)new AssertCachedRequestBodyGatewayFilter(CacheRequestBodyGatewayFilterFactoryTests.BODY_VALUE)).filter((GatewayFilter)new CheckCachedRequestBodyReleasedGatewayFilter())).uri(this.uri)).route("cache_request_body_empty_java_test", r -> r.path(new String[]{"/post"}).and().host(new String[]{"**.cacherequestbodyempty.org"}).filters(f -> f.prefixPath("/httpbin").cacheRequestBody(String.class).filter((GatewayFilter)new AssertCachedRequestBodyGatewayFilter(CacheRequestBodyGatewayFilterFactoryTests.BODY_EMPTY))).uri(this.uri)).route("cache_request_body_exists_java_test", r -> r.path(new String[]{"/post"}).and().host(new String[]{"**.cacherequestbodyexists.org"}).filters(f -> f.prefixPath("/httpbin").filter((GatewayFilter)new SetExchangeCachedRequestBodyGatewayFilter(CacheRequestBodyGatewayFilterFactoryTests.BODY_CACHED_EXISTS)).cacheRequestBody(String.class).filter((GatewayFilter)new AssertCachedRequestBodyGatewayFilter(CacheRequestBodyGatewayFilterFactoryTests.BODY_CACHED_EXISTS))).uri(this.uri)).build();
        }
    }
}

