/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.RequestHeaderSizeGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class RequestHeaderSizeGatewayFilterFactoryTest
extends BaseWebClientTests {
    private static final String longString = "11111111112222222222333333333344444444445555555";

    @Test
    public void setRequestHeaderSizeFilterWorks() {
        System.err.println("Here: " + longString.length() + ", " + longString.getBytes().length);
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.testrequestheadersizefilter.org"}).header("HeaderName", new String[]{longString}).exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE).expectHeader().value("errorMessage", header -> Assertions.assertThat((String)header).contains(new CharSequence[]{"permissible limit (46B)", "'HeaderName' is 57B"}));
    }

    @Test
    public void setRequestHeaderSizeFilterShortcutWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.requestheadersize.org"}).header("HeaderName", new String[]{longString}).exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE).expectHeader().value("errorMessage", header -> Assertions.assertThat((String)header).contains(new CharSequence[]{"permissible limit (46B)", "'HeaderName' is 57B"}));
    }

    @Test
    public void setRequestHeaderSizeFilterMultipleHeadersWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.requestheadersize.org"}).header("HeaderName", new String[]{longString}).header("HeaderName2", new String[]{longString}).exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE).expectHeader().value("errorMessage", header -> Assertions.assertThat((String)header).contains(new CharSequence[]{"permissible limit (46B)", "'HeaderName' is 57B", "'HeaderName2' is 58B"}));
    }

    @Test
    public void setRequestHeaderSizeFilterTakesIntoAccountHeaderName() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.testrequestheadersizefiltername.org"}).header("HeaderName", new String[]{longString}).exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE).expectHeader().value("errorMessage", header -> Assertions.assertThat((String)header).contains(new CharSequence[]{"permissible limit (47B)", "'HeaderName' is 57B"}));
    }

    @Test
    public void toStringFormat() {
        RequestHeaderSizeGatewayFilterFactory.Config config = new RequestHeaderSizeGatewayFilterFactory.Config();
        config.setMaxSize(DataSize.ofBytes((long)1000L));
        GatewayFilter filter = new RequestHeaderSizeGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"maxSize"})).contains(new CharSequence[]{"1000B"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_request_header_size", r -> r.order(-1).host(new String[]{"**.testrequestheadersizefilter.org"}).filters(f -> f.setRequestHeaderSize(DataSize.of((long)46L, (DataUnit)DataUnit.BYTES))).uri(this.uri)).route("test_request_header_size_name", r -> r.order(1).host(new String[]{"**.testrequestheadersizefiltername.org"}).filters(f -> f.setRequestHeaderSize(DataSize.of((long)47L, (DataUnit)DataUnit.BYTES))).uri(this.uri)).build();
        }
    }
}

