/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpMethod;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

@DirtiesContext
@ActiveProfiles(profiles={"local-cache-filter"})
public class LocalResponseCacheGatewayFilterFactoryTests
extends BaseWebClientTests {
    private static final String CUSTOM_HEADER = "X-Custom-Date";

    @Nested
    @SpringBootTest(properties={"spring.cloud.gateway.filter.local-response-cache.enabled=true", "spring.cloud.gateway.filter.local-response-cache.timeToLive=20s"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    public class LocalResponseCacheUsingDefaultProperties
    extends BaseWebClientTests {
        @Test
        void shouldApplyMaxAgeFromPropertiesWhenFilterHasNoParams() throws InterruptedException {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            Long maxAgeRequest1 = this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).exchange().expectBody().returnResult().getResponseHeaders().get((Object)"Cache-Control").stream().map(this::parseMaxAge).filter(Objects::nonNull).findAny().orElse(null);
            Assertions.assertThat((Long)maxAgeRequest1).isLessThanOrEqualTo(20L);
            Thread.sleep(2000L);
            Long maxAgeRequest2 = this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).exchange().expectBody().returnResult().getResponseHeaders().get((Object)"Cache-Control").stream().map(this::parseMaxAge).filter(Objects::nonNull).findAny().orElse(null);
            Assertions.assertThat((Long)maxAgeRequest2).isLessThan((Comparable)maxAgeRequest1);
        }

        private Long parseMaxAge(String cacheControlValue) {
            Pattern maxAgePattern;
            Matcher matcher;
            if (StringUtils.hasText((String)cacheControlValue) && (matcher = (maxAgePattern = Pattern.compile("\\bmax-age=(\\d+)\\b")).matcher(cacheControlValue)).find()) {
                return Long.parseLong(matcher.group(1));
            }
            return null;
        }

        @EnableAutoConfiguration
        @SpringBootConfiguration
        @Import(value={BaseWebClientTests.DefaultTestConfig.class})
        public static class TestConfig {
            @Value(value="${test.uri}")
            String uri;

            @Bean
            public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
                return builder.routes().route("local_response_cache_java_test", r -> r.path(new String[]{"/{namespace}/cache/**"}).and().host(new String[]{"{sub}.localresponsecache.org"}).filters(f -> f.stripPrefix(2).prefixPath("/httpbin").localResponseCache(null, null)).uri(this.uri)).build();
            }
        }
    }

    @Nested
    @SpringBootTest(properties={"spring.cloud.gateway.filter.local-response-cache.enabled=true"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    public class LocalResponseCacheUsingFilterParams
    extends BaseWebClientTests {
        @Test
        void shouldNotCacheResponseWhenGetRequestHasBody() {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.method(HttpMethod.GET).uri(uri, new Object[0])).header("Host", new String[]{"www.localresponsecache.org"})).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"})).bodyValue((Object)"whatever").exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]);
            ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.method(HttpMethod.GET).uri(uri, new Object[0])).header("Host", new String[]{"www.localresponsecache.org"})).bodyValue((Object)"whatever").header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]).isEqualTo((Object)"2");
        }

        @Test
        void shouldNotCacheResponseWhenPostRequestHasBody() {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.method(HttpMethod.POST).uri(uri, new Object[0])).header("Host", new String[]{"www.localresponsecache.org"})).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"})).bodyValue((Object)"whatever").exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]);
            ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.method(HttpMethod.POST).uri(uri, new Object[0])).header("Host", new String[]{"www.localresponsecache.org"})).bodyValue((Object)"whatever").header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]).isEqualTo((Object)"2");
        }

        @Test
        void shouldNotCacheWhenCacheControlAsksToDoNotCache() {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]);
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).header("Cache-Control", new String[]{CacheControl.noStore().getHeaderValue()}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]).isEqualTo((Object)"2");
        }

        @Test
        void shouldCacheAndReturnNotModifiedStatusWhenCacheControlIsNoCache() {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]);
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).header("Cache-Control", new String[]{CacheControl.noCache().getHeaderValue()}).exchange().expectStatus().isNotModified().expectBody().isEmpty();
        }

        @Test
        void shouldCacheResponseWhenOnlyNonVaryHeaderIsDifferent() {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]).value(customHeaderFromReq1 -> this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[]{customHeaderFromReq1}));
        }

        @Test
        void shouldNotCacheResponseWhenVaryHeaderIsDifferent() {
            String varyHeader = "Origin";
            String sameUri = "/" + UUID.randomUUID() + "/cache/vary-on-header";
            String firstNonVary = "1";
            String secondNonVary = "2";
            this.assertNonVaryHeaderInContent(sameUri, varyHeader, "origin-1", LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, firstNonVary, firstNonVary);
            this.assertNonVaryHeaderInContent(sameUri, varyHeader, "origin-1", LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, secondNonVary, firstNonVary);
            this.assertNonVaryHeaderInContent(sameUri, varyHeader, "origin-2", LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, secondNonVary, secondNonVary);
        }

        @Test
        void shouldNotCacheResponseWhenResponseVaryIsWildcard() {
            String uri = "/" + UUID.randomUUID() + "/cache/vary-on-header";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"}).header("X-Request-Vary", new String[]{"*"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[]{"1"});
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).header("X-Request-Vary", new String[]{"*"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[]{"2"});
        }

        @Test
        void shouldNotCacheResponseWhenPathIsDifferent() {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            String uri2 = "/" + UUID.randomUUID() + "/cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]);
            this.testClient.get().uri(uri2, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]).isEqualTo((Object)"2");
        }

        @Test
        void shouldDecreaseCacheControlMaxAgeTimeWhenResponseIsFromCache() throws InterruptedException {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            Long maxAgeRequest1 = this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).exchange().expectBody().returnResult().getResponseHeaders().get((Object)"Cache-Control").stream().map(this::parseMaxAge).filter(Objects::nonNull).findAny().orElse(null);
            Thread.sleep(2000L);
            Long maxAgeRequest2 = this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).exchange().expectBody().returnResult().getResponseHeaders().get((Object)"Cache-Control").stream().map(this::parseMaxAge).filter(Objects::nonNull).findAny().orElse(null);
            Assertions.assertThat((Long)maxAgeRequest2).isLessThan((Comparable)maxAgeRequest1);
        }

        @Test
        void shouldNotCacheResponseWhenTimeToLiveIsReached() {
            String uri = "/" + UUID.randomUUID() + "/ephemeral-cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]).value(customHeaderFromReq1 -> {
                try {
                    Thread.sleep(100L);
                    this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]).isEqualTo((Object)"2");
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        @Test
        void shouldNotCacheWhenLocalResponseCacheSizeIsReached() {
            String uri = "/" + UUID.randomUUID() + "/one-byte-cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]);
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[]{"2"});
        }

        @Test
        void shouldNotCacheWhenAuthorizationHeaderIsDifferent() {
            String uri = "/" + UUID.randomUUID() + "/cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header("Authorization", new String[]{"1"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[0]);
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header("Authorization", new String[]{"2"}).header(LocalResponseCacheGatewayFilterFactoryTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date", new Object[]{"2"});
        }

        private Long parseMaxAge(String cacheControlValue) {
            Pattern maxAgePattern;
            Matcher matcher;
            if (StringUtils.hasText((String)cacheControlValue) && (matcher = (maxAgePattern = Pattern.compile("\\bmax-age=(\\d+)\\b")).matcher(cacheControlValue)).find()) {
                return Long.parseLong(matcher.group(1));
            }
            return null;
        }

        void assertNonVaryHeaderInContent(String uri, String varyHeader, String varyHeaderValue, String nonVaryHeader, String nonVaryHeaderValue, String expectedNonVaryResponse) {
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header("X-Request-Vary", new String[]{varyHeader}).header(varyHeader, new String[]{varyHeaderValue}).header(nonVaryHeader, new String[]{nonVaryHeaderValue}).exchange().expectBody(Map.class).consumeWith(response -> {
                Assertions.assertThat((Map)response.getResponseHeaders()).hasEntrySatisfying((Object)"Vary", o -> Assertions.assertThat((List)o).contains((Object[])new String[]{varyHeader}));
                Assertions.assertThat((Map)((Map)((Map)response.getResponseBody()).get("headers"))).containsEntry((Object)nonVaryHeader, (Object)expectedNonVaryResponse);
            });
        }

        @EnableAutoConfiguration
        @SpringBootConfiguration
        @Import(value={BaseWebClientTests.DefaultTestConfig.class})
        public static class TestConfig {
            @Value(value="${test.uri}")
            String uri;

            @Bean
            public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
                return builder.routes().route("local_response_cache_java_test", r -> r.path(new String[]{"/{namespace}/cache/**"}).and().host(new String[]{"{sub}.localresponsecache.org"}).filters(f -> f.stripPrefix(2).prefixPath("/httpbin").localResponseCache(Duration.ofMinutes(2L), null)).uri(this.uri)).route("100_millisec_ephemeral_prefix_local_response_cache_java_test", r -> r.path(new String[]{"/{namespace}/ephemeral-cache/**"}).and().host(new String[]{"{sub}.localresponsecache.org"}).filters(f -> f.stripPrefix(2).prefixPath("/httpbin").localResponseCache(Duration.ofMillis(100L), null)).uri(this.uri)).route("min_sized_prefix_local_response_cache_java_test", r -> r.path(new String[]{"/{namespace}/one-byte-cache/**"}).and().host(new String[]{"{sub}.localresponsecache.org"}).filters(f -> f.stripPrefix(2).prefixPath("/httpbin").localResponseCache(null, DataSize.ofBytes((long)1L))).uri(this.uri)).build();
            }
        }
    }
}

