/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.SetMaxAgeHeaderAfterCacheExchangeMutator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

class SetMaxAgeHeaderAfterCacheExchangeMutatorTest {
    private static final int SECONDS_LATER = 10;
    private MockServerWebExchange inputExchange;
    private Clock clock;
    private Clock clockSecondsLater;

    SetMaxAgeHeaderAfterCacheExchangeMutatorTest() {
    }

    @BeforeEach
    void setUp() {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setCacheControl("max-age=1234");
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).build();
        this.inputExchange = MockServerWebExchange.from((MockServerHttpRequest)httpRequest);
        MockServerHttpResponse httpResponse = this.inputExchange.getResponse();
        httpResponse.setStatusCode((HttpStatusCode)HttpStatus.OK);
        httpResponse.getHeaders().putAll((Map)responseHeaders);
        this.clock = Clock.fixed(Instant.now(), Clock.systemDefaultZone().getZone());
        this.clockSecondsLater = Clock.fixed(this.clock.instant().plusSeconds(10L), this.clock.getZone());
    }

    @Test
    void maxAgeIsNotAdded_whenMaxAgeIsNotPresent() {
        this.inputExchange.getResponse().getHeaders().setCacheControl((String)null);
        Duration timeToLive = Duration.ofSeconds(30L);
        CachedResponse inputCachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).timestamp(this.clock.instant()).build();
        SetMaxAgeHeaderAfterCacheExchangeMutator toTest = new SetMaxAgeHeaderAfterCacheExchangeMutator(timeToLive, this.clock);
        toTest.accept((ServerWebExchange)this.inputExchange, inputCachedResponse);
        Assertions.assertThat(this.parseMaxAge((ServerHttpResponse)this.inputExchange.getResponse())).isEmpty();
    }

    @Test
    void maxAgeIsDecreasedByTimePassed_whenFilterIsAppliedAfterSecondsLater() {
        Duration timeToLive = Duration.ofSeconds(30L);
        CachedResponse inputCachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).timestamp(this.clock.instant()).build();
        SetMaxAgeHeaderAfterCacheExchangeMutator toTest = new SetMaxAgeHeaderAfterCacheExchangeMutator(timeToLive, this.clock);
        toTest.accept((ServerWebExchange)this.inputExchange, inputCachedResponse);
        Optional<Long> firstMaxAgeSeconds = this.parseMaxAge((ServerHttpResponse)this.inputExchange.getResponse());
        SetMaxAgeHeaderAfterCacheExchangeMutator toTestSecondsLater = new SetMaxAgeHeaderAfterCacheExchangeMutator(timeToLive, this.clockSecondsLater);
        toTestSecondsLater.accept((ServerWebExchange)this.inputExchange, inputCachedResponse);
        Optional<Long> secondMaxAgeSeconds = this.parseMaxAge((ServerHttpResponse)this.inputExchange.getResponse());
        Assertions.assertThat(firstMaxAgeSeconds).contains((Object)timeToLive.getSeconds());
        Assertions.assertThat(secondMaxAgeSeconds).contains((Object)(timeToLive.getSeconds() - 10L));
    }

    @Test
    void maxAgeIsZero_whenRequestIsCachedMoreThanTimeToLive() {
        Duration timeToLive = Duration.ofSeconds(5L);
        CachedResponse inputCachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).timestamp(this.clock.instant()).build();
        SetMaxAgeHeaderAfterCacheExchangeMutator toTest = new SetMaxAgeHeaderAfterCacheExchangeMutator(timeToLive, this.clock);
        toTest.accept((ServerWebExchange)this.inputExchange, inputCachedResponse);
        Optional<Long> firstMaxAgeSeconds = this.parseMaxAge((ServerHttpResponse)this.inputExchange.getResponse());
        SetMaxAgeHeaderAfterCacheExchangeMutator toTestSecondsLater = new SetMaxAgeHeaderAfterCacheExchangeMutator(timeToLive, this.clockSecondsLater);
        toTestSecondsLater.accept((ServerWebExchange)this.inputExchange, inputCachedResponse);
        Optional<Long> secondMaxAgeSeconds = this.parseMaxAge((ServerHttpResponse)this.inputExchange.getResponse());
        Assertions.assertThat(firstMaxAgeSeconds).contains((Object)timeToLive.getSeconds());
        Assertions.assertThat(secondMaxAgeSeconds).contains((Object)0L);
    }

    @Test
    void otherCacheControlValuesAreNotRemoved_whenMaxAgeIsModified() {
        this.inputExchange.getResponse().getHeaders().setCacheControl("max-stale=12, min-stale=1, max-age=1234");
        Duration timeToLive = Duration.ofSeconds(30L);
        CachedResponse inputCachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).timestamp(this.clock.instant()).build();
        SetMaxAgeHeaderAfterCacheExchangeMutator toTest = new SetMaxAgeHeaderAfterCacheExchangeMutator(timeToLive, this.clock);
        toTest.accept((ServerWebExchange)this.inputExchange, inputCachedResponse);
        Object[] cacheControlValues = Optional.ofNullable(this.inputExchange.getResponse().getHeaders().getCacheControl()).map(s -> s.split("\\s*,\\s*")).orElse(null);
        Assertions.assertThat((Object[])cacheControlValues).contains((Object[])new String[]{"max-stale=12", "min-stale=1"});
    }

    @Test
    void otherHeadersAreNotRemoved_whenMaxAgeIsModified() {
        this.inputExchange.getResponse().getHeaders().put("X-Custom-Header", List.of("DO-NOT-REMOVE"));
        Duration timeToLive = Duration.ofSeconds(30L);
        CachedResponse inputCachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).timestamp(this.clock.instant()).build();
        SetMaxAgeHeaderAfterCacheExchangeMutator toTest = new SetMaxAgeHeaderAfterCacheExchangeMutator(timeToLive, this.clock);
        toTest.accept((ServerWebExchange)this.inputExchange, inputCachedResponse);
        List cacheControlValues = this.inputExchange.getResponse().getHeaders().get((Object)"X-Custom-Header");
        Assertions.assertThat((List)cacheControlValues).contains((Object[])new String[]{"DO-NOT-REMOVE"});
    }

    private Optional<Long> parseMaxAge(ServerHttpResponse response) {
        return this.parseMaxAge(response.getHeaders().getCacheControl());
    }

    private Optional<Long> parseMaxAge(String cacheControlValue) {
        Pattern maxAgePattern;
        Matcher matcher;
        if (StringUtils.hasText((String)cacheControlValue) && (matcher = (maxAgePattern = Pattern.compile("\\bmax-age=(\\d+)\\b")).matcher(cacheControlValue)).find()) {
            return Optional.of(Long.parseLong(matcher.group(1)));
        }
        return Optional.empty();
    }
}

