/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.SetStatusCodeAfterCacheExchangeMutator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

class SetStatusCodeAfterCacheExchangeMutatorTest {
    private MockServerWebExchange inputExchange;

    SetStatusCodeAfterCacheExchangeMutatorTest() {
    }

    @BeforeEach
    void setUp() {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setCacheControl("max-age=1234");
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).build();
        this.inputExchange = MockServerWebExchange.from((MockServerHttpRequest)httpRequest);
        MockServerHttpResponse httpResponse = this.inputExchange.getResponse();
        httpResponse.setStatusCode((HttpStatusCode)HttpStatus.OK);
        httpResponse.getHeaders().putAll((Map)responseHeaders);
    }

    @Test
    void statusCodeIs304_whenCacheHitsAndNoCacheHeaderIsPresent() {
        CachedResponse cachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).body("some-data").build();
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).header("Cache-Control", new String[]{"no-cache"}).build();
        this.inputExchange = MockServerWebExchange.from((MockServerHttpRequest)httpRequest);
        SetStatusCodeAfterCacheExchangeMutator toTest = new SetStatusCodeAfterCacheExchangeMutator();
        toTest.accept((ServerWebExchange)this.inputExchange, cachedResponse);
        Assertions.assertThat((Object)this.inputExchange.getResponse().getStatusCode()).isEqualTo((Object)HttpStatus.NOT_MODIFIED);
    }

    @Test
    void statusCodeIs200_whenCacheHitsAndNoCacheHeaderIsNotPresent() {
        CachedResponse cachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).body("some-data").build();
        SetStatusCodeAfterCacheExchangeMutator toTest = new SetStatusCodeAfterCacheExchangeMutator();
        toTest.accept((ServerWebExchange)this.inputExchange, cachedResponse);
        Assertions.assertThat((Object)this.inputExchange.getResponse().getStatusCode()).isEqualTo((Object)HttpStatus.OK);
    }

    @Test
    void statusCodeIs200_whenNoCacheHitsAndEvenNoCacheHeaderIsPresent() {
        CachedResponse cachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).build();
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).header("Cache-Control", new String[]{"no-cache"}).build();
        this.inputExchange = MockServerWebExchange.from((MockServerHttpRequest)httpRequest);
        SetStatusCodeAfterCacheExchangeMutator toTest = new SetStatusCodeAfterCacheExchangeMutator();
        toTest.accept((ServerWebExchange)this.inputExchange, cachedResponse);
        Assertions.assertThat((Object)this.inputExchange.getResponse().getStatusCode()).isEqualTo((Object)HttpStatus.OK);
    }
}

