/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.boot.test.system.OutputCaptureExtension;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.core.env.Environment;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

@ExtendWith(value={OutputCaptureExtension.class})
public class RoutePredicateHandlerMappingTests {
    @Test
    public void lookupRouteFromSyncPredicates(CapturedOutput capturedOutput) {
        final Route routeFalse = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeFalse")).uri("http://localhost")).predicate(swe -> false).build();
        final Route routeFail = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeFail")).uri("http://localhost")).predicate(swe -> {
            throw new IllegalStateException("boom");
        }).build();
        final Route routeTrue = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeTrue")).uri("http://localhost")).predicate(swe -> true).build();
        RouteLocator routeLocator2 = new RouteLocator(){

            public Flux<Route> getRoutes() {
                return Flux.just((Object[])new Route[]{routeFalse, routeFail, routeTrue}).hide();
            }
        };
        RoutePredicateHandlerMapping mapping = new RoutePredicateHandlerMapping(null, routeLocator2, new GlobalCorsProperties(), (Environment)new MockEnvironment());
        Mono routeMono = mapping.lookupRoute((ServerWebExchange)Mockito.mock(ServerWebExchange.class));
        StepVerifier.create((Publisher)routeMono.map(Route::getId)).expectNext((Object)"routeTrue").verifyComplete();
        Assertions.assertTrue((boolean)capturedOutput.getOut().contains("Error applying predicate for route: routeFail"));
        Assertions.assertTrue((boolean)capturedOutput.getOut().contains("java.lang.IllegalStateException: boom"));
    }

    @Test
    public void lookupRouteFromAsyncPredicates(CapturedOutput capturedOutput) {
        Route routeFalse = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeFalse")).uri("http://localhost")).asyncPredicate(swe -> Mono.just((Object)false)).build();
        Route routeError = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeError")).uri("http://localhost")).asyncPredicate(swe -> Mono.error((Throwable)new IllegalStateException("boom1"))).build();
        Route routeFail = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeFail")).uri("http://localhost")).asyncPredicate(swe -> {
            throw new IllegalStateException("boom2");
        }).build();
        Route routeTrue = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeTrue")).uri("http://localhost")).asyncPredicate(swe -> Mono.just((Object)true)).build();
        RouteLocator routeLocator2 = () -> Flux.just((Object[])new Route[]{routeFalse, routeError, routeFail, routeTrue}).hide();
        RoutePredicateHandlerMapping mapping = new RoutePredicateHandlerMapping(null, routeLocator2, new GlobalCorsProperties(), (Environment)new MockEnvironment());
        Mono routeMono = mapping.lookupRoute((ServerWebExchange)Mockito.mock(ServerWebExchange.class));
        StepVerifier.create((Publisher)routeMono.map(Route::getId)).expectNext((Object)"routeTrue").verifyComplete();
        Assertions.assertTrue((boolean)capturedOutput.getOut().contains("Error applying predicate for route: routeError"));
        Assertions.assertTrue((boolean)capturedOutput.getOut().contains("java.lang.IllegalStateException: boom1"));
        Assertions.assertTrue((boolean)capturedOutput.getOut().contains("Error applying predicate for route: routeFail"));
        Assertions.assertTrue((boolean)capturedOutput.getOut().contains("java.lang.IllegalStateException: boom2"));
    }
}

