/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
class CookieRoutePredicateFactoryIntegrationTests
extends BaseWebClientTests {
    CookieRoutePredicateFactoryIntegrationTests() {
    }

    @Test
    void cookieRegexWorks() {
        this.assertCookieValue("helloaaaaa");
        this.assertCookieValue("hello");
    }

    private void assertCookieValue(String value) {
        this.testClient.get().uri("/cookie", new Object[0]).header("Host", new String[]{"www.cookieregex.org"}).cookie("mycookie", value).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"cookie_regex_test"}).expectBody(String.class).isEqualTo((Object)value);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    @RestController
    static class TestConfig {
        TestConfig() {
        }

        @GetMapping(value={"/httpbin/cookie"})
        String cookie(@CookieValue(value="mycookie") String mycookie) {
            return mycookie;
        }
    }
}

