/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.ReadBodyRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.BodyInserters;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class ReadBodyRoutePredicateFactoryTests {
    @Autowired
    private WebTestClient webClient;

    @Test
    public void readBodyWorks() {
        Event messageEvent = new Event("message", "bar");
        Event messageChannelEvent = new Event("message.channels", "bar");
        ((WebTestClient.RequestBodySpec)this.webClient.post().uri("/events", new Object[0])).body(BodyInserters.fromValue((Object)messageEvent)).exchange().expectStatus().isOk().expectBody().jsonPath("$.headers.Hello", new Object[0]).isEqualTo((Object)"World");
        ((WebTestClient.RequestBodySpec)this.webClient.post().uri("/events", new Object[0])).body(BodyInserters.fromValue((Object)messageChannelEvent)).exchange().expectStatus().isOk().expectBody().jsonPath("$.headers.World", new Object[0]).isEqualTo((Object)"Hello");
    }

    @Test
    public void toStringFormat() {
        ReadBodyRoutePredicateFactory.Config config = new ReadBodyRoutePredicateFactory.Config();
        config.setInClass(String.class);
        AsyncPredicate predicate = new ReadBodyRoutePredicateFactory().applyAsync(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"ReadBody: " + config.getInClass()});
    }

    static class Event {
        private String foo;
        private String bar;

        Event() {
        }

        Event(String foo, String bar) {
            this.foo = foo;
            this.bar = bar;
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @LoadBalancerClients(value={@LoadBalancerClient(name="message", configuration={BaseWebClientTests.TestLoadBalancerConfig.class}), @LoadBalancerClient(name="messageChannel", configuration={BaseWebClientTests.TestLoadBalancerConfig.class})})
    @Import(value={PermitAllSecurityConfiguration.class})
    @RestController
    public static class TestConfig {
        @Bean
        public RouteLocator routeLocator(RouteLocatorBuilder builder) {
            return builder.routes().route(p -> p.path(new String[]{"/events"}).and().method(new HttpMethod[]{HttpMethod.POST}).and().readBody(Event.class, this.eventPredicate("message.channels")).filters(f -> f.setPath("/messageChannel/events")).uri("lb://messageChannel")).route(p -> p.path(new String[]{"/events"}).and().method(new HttpMethod[]{HttpMethod.POST}).and().readBody(Event.class, this.eventPredicate("message")).filters(f -> f.setPath("/message/events")).uri("lb://message")).build();
        }

        private Predicate<Event> eventPredicate(String type) {
            return r -> r.getFoo().equals(type);
        }

        @PostMapping(path={"message/events"}, produces={"application/json"})
        public String messageEvents(@RequestBody Event e) {
            return "{\"headers\":{\"Hello\":\"World\"}}";
        }

        @PostMapping(path={"messageChannel/events"}, produces={"application/json"})
        public String messageChannelEvents(@RequestBody Event e) {
            return "{\"headers\":{\"World\":\"Hello\"}}";
        }
    }
}

