/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.TrustManagerFactory;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.reactive.ReactiveOAuth2ClientAutoConfiguration;
import org.springframework.boot.autoconfigure.security.reactive.ReactiveSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.runner.ReactiveWebApplicationContextRunner;
import org.springframework.cloud.gateway.actuate.GatewayControllerEndpoint;
import org.springframework.cloud.gateway.actuate.GatewayLegacyControllerEndpoint;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.cloud.gateway.config.GatewayReactiveOAuth2AutoConfiguration;
import org.springframework.cloud.gateway.config.HttpClientCustomizer;
import org.springframework.cloud.gateway.config.HttpClientFactory;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.cloud.gateway.config.HttpClientSslConfigurer;
import org.springframework.cloud.gateway.filter.factory.TokenRelayGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.headers.GRPCRequestHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.GRPCResponseHeadersFilter;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.GatewayFilterSpec;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.web.filter.reactive.HiddenHttpMethodFilter;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.server.upgrade.ReactorNettyRequestUpgradeStrategy;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ProxyProvider;

public class GatewayAutoConfigurationTests {
    @Test
    public void noHiddenHttpMethodFilter() {
        try (ConfigurableApplicationContext ctx = SpringApplication.run(Config.class, (String[])new String[]{"--spring.jmx.enabled=false", "--server.port=0"});){
            Assertions.assertThat((String)ctx.getEnvironment().getProperty("spring.webflux.hiddenmethod.filter.enabled")).isEqualTo("false");
            Assertions.assertThat((Object[])ctx.getBeanNamesForType(HiddenHttpMethodFilter.class)).isEmpty();
        }
    }

    @Test
    public void nettyHttpClientDefaults() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{WebFluxAutoConfiguration.class, MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GatewayAutoConfiguration.class, ServerPropertiesConfig.class}))).withPropertyValues(new String[]{"debug=true"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(HttpClient.class);
            HttpClient httpClient = (HttpClient)context.getBean(HttpClient.class);
            CustomHttpClientFactory factory = (CustomHttpClientFactory)((Object)((Object)context.getBean(CustomHttpClientFactory.class)));
            Assertions.assertThat((Object)factory.connectionProvider).isNotNull();
            Assertions.assertThat((int)factory.connectionProvider.maxConnections()).isEqualTo(Integer.MAX_VALUE);
            Assertions.assertThat((Object)factory.proxyProvider).isNull();
            Assertions.assertThat((boolean)factory.isSslConfigured()).isFalse();
            Assertions.assertThat((boolean)((HttpClientConfig)httpClient.configuration()).isAcceptGzip()).isFalse();
            Assertions.assertThat((Object)((HttpClientConfig)httpClient.configuration()).loggingHandler()).isNull();
            Assertions.assertThat((Map)((HttpClientConfig)httpClient.configuration()).options()).doesNotContainKey((Object)ChannelOption.CONNECT_TIMEOUT_MILLIS);
        });
    }

    @Test
    public void nettyHttpClientConfigured() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{WebFluxAutoConfiguration.class, MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GatewayAutoConfiguration.class, HttpClientCustomizedConfig.class, ServerPropertiesConfig.class}))).withPropertyValues(new String[]{"spring.cloud.gateway.httpclient.ssl.use-insecure-trust-manager=true", "spring.cloud.gateway.httpclient.connect-timeout=10", "spring.cloud.gateway.httpclient.response-timeout=10s", "spring.cloud.gateway.httpclient.pool.eviction-interval=10s", "spring.cloud.gateway.httpclient.pool.type=fixed", "spring.cloud.gateway.httpclient.pool.metrics=true", "spring.cloud.gateway.httpclient.compression=true", "spring.cloud.gateway.httpclient.wiretap=true", "spring.cloud.gateway.httpclient.max-initial-line-length=2147483647", "spring.cloud.gateway.httpclient.proxy.host=myhost", "spring.cloud.gateway.httpclient.websocket.max-frame-payload-length=1024"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(HttpClient.class);
            HttpClient httpClient = (HttpClient)context.getBean(HttpClient.class);
            CustomHttpClientFactory factory = (CustomHttpClientFactory)((Object)((Object)context.getBean(CustomHttpClientFactory.class)));
            HttpClientProperties properties = (HttpClientProperties)context.getBean(HttpClientProperties.class);
            Assertions.assertThat((long)properties.getMaxInitialLineLength().toBytes()).isLessThanOrEqualTo(Integer.MAX_VALUE);
            Assertions.assertThat((boolean)properties.isCompression()).isEqualTo(true);
            Assertions.assertThat((Duration)properties.getPool().getEvictionInterval()).hasSeconds(10L);
            Assertions.assertThat((boolean)properties.getPool().isMetrics()).isEqualTo(true);
            Assertions.assertThat((boolean)((HttpClientConfig)httpClient.configuration()).isAcceptGzip()).isTrue();
            Assertions.assertThat((Object)((HttpClientConfig)httpClient.configuration()).loggingHandler()).isNotNull();
            Assertions.assertThat((Map)((HttpClientConfig)httpClient.configuration()).options()).containsKey((Object)ChannelOption.CONNECT_TIMEOUT_MILLIS);
            Assertions.assertThat(((HttpClientConfig)httpClient.configuration()).options().get(ChannelOption.CONNECT_TIMEOUT_MILLIS)).isEqualTo((Object)10);
            Assertions.assertThat((Object)factory.connectionProvider).isNotNull();
            Assertions.assertThat((int)factory.connectionProvider.maxConnections()).isEqualTo(ConnectionProvider.DEFAULT_POOL_MAX_CONNECTIONS);
            Assertions.assertThat((Object)factory.proxyProvider).isNotNull();
            Assertions.assertThat((String)((InetSocketAddress)factory.proxyProvider.build().getAddress().get()).getHostName()).isEqualTo("myhost");
            Assertions.assertThat((boolean)factory.isSslConfigured()).isTrue();
            Assertions.assertThat((boolean)factory.isInsecureTrustManagerSet()).isTrue();
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(ReactorNettyRequestUpgradeStrategy.class);
            ReactorNettyRequestUpgradeStrategy upgradeStrategy = (ReactorNettyRequestUpgradeStrategy)context.getBean(ReactorNettyRequestUpgradeStrategy.class);
            Assertions.assertThat((int)upgradeStrategy.getWebsocketServerSpec().maxFramePayloadLength()).isEqualTo(1024);
            Assertions.assertThat((boolean)upgradeStrategy.getWebsocketServerSpec().handlePing()).isTrue();
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(ReactorNettyWebSocketClient.class);
            ReactorNettyWebSocketClient webSocketClient = (ReactorNettyWebSocketClient)context.getBean(ReactorNettyWebSocketClient.class);
            Assertions.assertThat((int)webSocketClient.getWebsocketClientSpec().maxFramePayloadLength()).isEqualTo(1024);
            HttpClientCustomizedConfig config = (HttpClientCustomizedConfig)context.getBean(HttpClientCustomizedConfig.class);
            Assertions.assertThat((boolean)config.called.get()).isTrue();
        });
    }

    @Test
    public void verboseActuatorEnabledByDefault() {
        try (ConfigurableApplicationContext ctx = SpringApplication.run(Config.class, (String[])new String[]{"--spring.jmx.enabled=false", "--server.port=0", "--management.endpoint.gateway.enabled=true"});){
            Assertions.assertThat((Object[])ctx.getBeanNamesForType(GatewayControllerEndpoint.class)).hasSize(1);
            Assertions.assertThat((Object[])ctx.getBeanNamesForType(GatewayLegacyControllerEndpoint.class)).isEmpty();
        }
    }

    @Test
    public void verboseActuatorDisabled() {
        try (ConfigurableApplicationContext ctx = SpringApplication.run(Config.class, (String[])new String[]{"--spring.jmx.enabled=false", "--server.port=0", "--spring.cloud.gateway.actuator.verbose.enabled=false", "--management.endpoint.gateway.enabled=true"});){
            Assertions.assertThat((Object[])ctx.getBeanNamesForType(GatewayLegacyControllerEndpoint.class)).hasSize(1);
        }
    }

    @Test
    public void tokenRelayBeansAreCreated() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{ReactiveSecurityAutoConfiguration.class, ReactiveOAuth2ClientAutoConfiguration.class, GatewayReactiveOAuth2AutoConfiguration.class, GatewayAutoConfiguration.TokenRelayConfiguration.class}))).withPropertyValues(new String[]{"spring.security.oauth2.client.provider[testprovider].authorization-uri=http://localhost", "spring.security.oauth2.client.provider[testprovider].token-uri=http://localhost/token", "spring.security.oauth2.client.registration[test].provider=testprovider", "spring.security.oauth2.client.registration[test].authorization-grant-type=authorization_code", "spring.security.oauth2.client.registration[test].redirect-uri=http://localhost/redirect", "spring.security.oauth2.client.registration[test].client-id=login-client"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(ReactiveOAuth2AuthorizedClientManager.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(TokenRelayGatewayFilterFactory.class);
        });
    }

    @Test
    public void gatewayReactiveOAuth2AuthorizedClientManagerBacksOffForCustomBean() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{ReactiveSecurityAutoConfiguration.class, ReactiveOAuth2ClientAutoConfiguration.class, GatewayReactiveOAuth2AutoConfiguration.class}))).withUserConfiguration(new Class[]{TestReactiveOAuth2AuthorizedClientManagerConfig.class})).withPropertyValues(new String[]{"spring.security.oauth2.client.provider[testprovider].authorization-uri=http://localhost", "spring.security.oauth2.client.provider[testprovider].token-uri=http://localhost/token", "spring.security.oauth2.client.registration[test].provider=testprovider", "spring.security.oauth2.client.registration[test].authorization-grant-type=authorization_code", "spring.security.oauth2.client.registration[test].redirect-uri=http://localhost/redirect", "spring.security.oauth2.client.registration[test].client-id=login-client"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(ReactiveOAuth2AuthorizedClientManager.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasBean("myReactiveOAuth2AuthorizedClientManager");
        });
    }

    @Test
    public void noTokenRelayFilter() {
        Assertions.assertThatThrownBy(() -> {
            try (ConfigurableApplicationContext ctx = SpringApplication.run(RouteLocatorBuilderConfig.class, (String[])new String[]{"--spring.jmx.enabled=false", "--spring.cloud.gateway.filter.token-relay.enabled=false", "--spring.security.oauth2.client.provider[testprovider].authorization-uri=http://localhost", "--spring.security.oauth2.client.provider[testprovider].token-uri=http://localhost/token", "--spring.security.oauth2.client.registration[test].provider=testprovider", "--spring.security.oauth2.client.registration[test].authorization-grant-type=authorization_code", "--spring.security.oauth2.client.registration[test].redirect-uri=http://localhost/redirect", "--spring.security.oauth2.client.registration[test].client-id=login-client", "--server.port=0", "--spring.cloud.gateway.actuator.verbose.enabled=false"});){
                Assertions.assertThat((Object[])ctx.getBeanNamesForType(GatewayLegacyControllerEndpoint.class)).hasSize(1);
            }
        }).hasRootCauseInstanceOf(IllegalStateException.class).hasMessageContaining("No TokenRelayGatewayFilterFactory bean was found. Did you include");
    }

    @Test
    public void reactorNettyRequestUpgradeStrategyWebSocketSpecBuilderIsUniquePerRequest() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ReactorNettyRequestUpgradeStrategy strategy = new GatewayAutoConfiguration.NettyConfiguration().reactorNettyRequestUpgradeStrategy(new HttpClientProperties());
        Method buildSpec = ReactorNettyRequestUpgradeStrategy.class.getDeclaredMethod("buildSpec", String.class);
        buildSpec.setAccessible(true);
        WebsocketServerSpec spec1 = (WebsocketServerSpec)buildSpec.invoke((Object)strategy, "p1");
        WebsocketServerSpec spec2 = strategy.getWebsocketServerSpec();
        Assertions.assertThat((String)spec1.protocols()).isEqualTo("p1");
        Assertions.assertThat((String)spec2.protocols()).isNull();
    }

    @Test
    public void webSocketClientSpecBuilderIsUniquePerReactorNettyWebSocketClient() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ReactorNettyWebSocketClient websocketClient = new GatewayAutoConfiguration.NettyConfiguration().reactorNettyWebSocketClient(new HttpClientProperties(), HttpClient.create());
        Method buildSpec = ReactorNettyWebSocketClient.class.getDeclaredMethod("buildSpec", String.class);
        buildSpec.setAccessible(true);
        WebsocketClientSpec spec1 = (WebsocketClientSpec)buildSpec.invoke((Object)websocketClient, "p1");
        WebsocketClientSpec spec2 = websocketClient.getWebsocketClientSpec();
        Assertions.assertThat((String)spec1.protocols()).isEqualTo("p1");
        Assertions.assertThat((String)spec2.protocols()).isNull();
    }

    @Test
    public void gRPCFiltersConfiguredWhenHTTP2Enabled() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{WebFluxAutoConfiguration.class, MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GatewayAutoConfiguration.class, HttpClientCustomizedConfig.class, ServerPropertiesConfig.class}))).withPropertyValues(new String[]{"server.http2.enabled=true"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(GRPCRequestHeadersFilter.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(GRPCResponseHeadersFilter.class);
            HttpClient httpClient = (HttpClient)context.getBean(HttpClient.class);
            Assertions.assertThat((Object[])((HttpClientConfig)httpClient.configuration()).protocols()).contains((Object[])new HttpProtocol[]{HttpProtocol.HTTP11, HttpProtocol.H2});
        });
    }

    @Test
    public void gRPCFiltersNotConfiguredWhenHTTP2Disabled() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{WebFluxAutoConfiguration.class, MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GatewayAutoConfiguration.class, HttpClientCustomizedConfig.class, ServerPropertiesConfig.class}))).withPropertyValues(new String[]{"server.http2.enabled=false"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(GRPCRequestHeadersFilter.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(GRPCResponseHeadersFilter.class);
        });
    }

    @Test
    public void insecureTrustManagerNotEnabledByDefaultWhenHTTP2Enabled() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{WebFluxAutoConfiguration.class, MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GatewayAutoConfiguration.class, HttpClientCustomizedConfig.class, ServerPropertiesConfig.class}))).withPropertyValues(new String[]{"server.http2.enabled=true"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(HttpClient.class);
            CustomHttpClientFactory factory = (CustomHttpClientFactory)((Object)((Object)context.getBean(CustomHttpClientFactory.class)));
            Assertions.assertThat((boolean)factory.isInsecureTrustManagerSet()).isFalse();
        });
    }

    @Test
    public void customHttpClientWorks() {
        ((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{WebFluxAutoConfiguration.class, MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GatewayAutoConfiguration.class, HttpClientCustomizedConfig.class, CustomHttpClientConfig.class}))).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(HttpClient.class);
            HttpClient httpClient = (HttpClient)context.getBean(HttpClient.class);
            Assertions.assertThat((Object)httpClient).isInstanceOf(CustomHttpClient.class);
        });
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    protected static class Config {
        protected Config() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={ServerProperties.class})
    @AutoConfigureBefore(value={GatewayAutoConfiguration.class})
    protected static class ServerPropertiesConfig {
        protected ServerPropertiesConfig() {
        }

        @Bean
        @Primary
        CustomHttpClientFactory customHttpClientFactory(HttpClientProperties properties, ServerProperties serverProperties, List<HttpClientCustomizer> customizers, HttpClientSslConfigurer sslConfigurer) {
            return new CustomHttpClientFactory(properties, serverProperties, sslConfigurer, customizers);
        }

        @Bean
        @Primary
        CustomHttpClientFactory.CustomSslConfigurer customSslContextFactory(ServerProperties serverProperties, HttpClientProperties httpClientProperties) {
            return new CustomHttpClientFactory.CustomSslConfigurer(httpClientProperties.getSsl(), serverProperties);
        }
    }

    @Configuration
    protected static class HttpClientCustomizedConfig {
        private final AtomicBoolean called = new AtomicBoolean();

        protected HttpClientCustomizedConfig() {
        }

        @Bean
        HttpClientCustomizer myCustomCustomizer() {
            return httpClient -> {
                this.called.compareAndSet(false, true);
                return httpClient;
            };
        }
    }

    @Configuration
    protected static class TestReactiveOAuth2AuthorizedClientManagerConfig {
        protected TestReactiveOAuth2AuthorizedClientManagerConfig() {
        }

        @Bean
        ReactiveOAuth2AuthorizedClientManager myReactiveOAuth2AuthorizedClientManager() {
            return authorizeRequest -> null;
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @EnableConfigurationProperties(value={ServerProperties.class})
    @AutoConfigureBefore(value={GatewayAutoConfiguration.class})
    protected static class CustomHttpClientConfig {
        protected CustomHttpClientConfig() {
        }

        @Bean
        public HttpClient customHttpClient() {
            return new CustomHttpClient();
        }
    }

    protected static class CustomHttpClient
    extends HttpClient {
        protected CustomHttpClient() {
        }

        public HttpClientConfig configuration() {
            return null;
        }

        protected HttpClient duplicate() {
            return this;
        }
    }

    protected static class CustomHttpClientFactory
    extends HttpClientFactory {
        private ConnectionProvider connectionProvider;
        private ProxyProvider.Builder proxyProvider;
        private CustomSslConfigurer customSslContextFactory;

        public CustomHttpClientFactory(HttpClientProperties properties, ServerProperties serverProperties, HttpClientSslConfigurer sslConfigurer, List<HttpClientCustomizer> customizers) {
            super(properties, serverProperties, sslConfigurer, customizers);
            this.customSslContextFactory = (CustomSslConfigurer)sslConfigurer;
        }

        protected ConnectionProvider buildConnectionProvider(HttpClientProperties properties) {
            this.connectionProvider = super.buildConnectionProvider(properties);
            return this.connectionProvider;
        }

        protected ProxyProvider.Builder configureProxyProvider(HttpClientProperties.Proxy proxy, ProxyProvider.TypeSpec proxySpec) {
            this.proxyProvider = super.configureProxyProvider(proxy, proxySpec);
            return this.proxyProvider;
        }

        public boolean isSslConfigured() {
            return this.customSslContextFactory.sslConfigured;
        }

        public boolean isInsecureTrustManagerSet() {
            return this.customSslContextFactory.insecureTrustManagerSet;
        }

        protected static class CustomSslConfigurer
        extends HttpClientSslConfigurer {
            boolean sslConfigured;
            boolean insecureTrustManagerSet;

            protected CustomSslConfigurer(HttpClientProperties.Ssl sslProperties, ServerProperties serverProperties) {
                super(sslProperties, serverProperties);
            }

            protected void configureSslContext(HttpClientProperties.Ssl ssl, SslProvider.SslContextSpec sslContextSpec) {
                this.sslConfigured = true;
                super.configureSslContext(this.getSslProperties(), sslContextSpec);
            }

            protected void setTrustManager(SslContextBuilder sslContextBuilder, TrustManagerFactory factory) {
                this.insecureTrustManagerSet = factory == InsecureTrustManagerFactory.INSTANCE;
                super.setTrustManager(sslContextBuilder, factory);
            }
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    protected static class RouteLocatorBuilderConfig {
        protected RouteLocatorBuilderConfig() {
        }

        @Bean
        public RouteLocator myRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test", r -> r.alwaysTrue().filters(GatewayFilterSpec::tokenRelay).uri("http://localhost")).build();
        }
    }
}

