/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.handler.predicate.AfterRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BeforeRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;
import org.springframework.test.context.ActiveProfiles;

public class DisableBuiltInPredicatesTests {

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.predicate.after.enabled=false", "spring.cloud.gateway.predicate.before.enabled=false", "spring.cloud.gateway.predicate.between.enabled=false", "spring.cloud.gateway.predicate.cookie.enabled=false", "spring.cloud.gateway.predicate.header.enabled=false", "spring.cloud.gateway.predicate.host.enabled=false", "spring.cloud.gateway.predicate.method.enabled=false", "spring.cloud.gateway.predicate.path.enabled=false", "spring.cloud.gateway.predicate.query.enabled=false", "spring.cloud.gateway.predicate.read-body.enabled=false", "spring.cloud.gateway.predicate.remote-addr.enabled=false", "spring.cloud.gateway.predicate.xforwarded-remote-addr.enabled=false", "spring.cloud.gateway.predicate.weight.enabled=false", "spring.cloud.gateway.predicate.cloud-foundry-route-service.enabled=false"})
    @ActiveProfiles(value={"disable-components"})
    public class DisableAllPredicatesByProperty {
        @Autowired(required=false)
        private List<RoutePredicateFactory<?>> predicates;

        @Test
        public void shouldDisableAllBuiltInPredicates() {
            Assertions.assertThat(this.predicates).isNull();
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.predicate.after.enabled=false", "spring.cloud.gateway.predicate.before.enabled=false"})
    @ActiveProfiles(value={"disable-components"})
    public class DisableSpecificsPredicatesByProperty {
        @Autowired
        private List<RoutePredicateFactory<?>> predicates;

        @Test
        public void shouldInjectOnlyEnabledBuiltInPredicates() {
            Assertions.assertThat(this.predicates).hasSizeGreaterThan(0);
            Assertions.assertThat(this.predicates).allSatisfy(filter -> Assertions.assertThat((Object)filter).isNotInstanceOfAny(new Class[]{AfterRoutePredicateFactory.class, BeforeRoutePredicateFactory.class}));
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class})
    public class RoutePredicateDefault {
        @Autowired
        private List<RoutePredicateFactory<?>> predicates;

        @Test
        public void shouldInjectBuiltInPredicates() {
            Assertions.assertThat(this.predicates).hasSizeGreaterThanOrEqualTo(13);
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    protected static class Config {
        protected Config() {
        }
    }
}

