/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.cors;

import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import reactor.core.publisher.Mono;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.gateway.globalcors.add-to-simple-url-handler-mapping=true"})
@DirtiesContext
@ActiveProfiles(value={"request-header-web-filter"})
public class SimpleUrlHandlerCorsTests
extends BaseWebClientTests {
    @Test
    public void testPreFlightCorsRequestNotHandledByGW() {
        ResponseEntity response = (ResponseEntity)this.webClient.options().uri("/abc/123/function", new Object[0]).header("Origin", new String[]{"domain.com"}).header("Access-Control-Request-Method", new String[]{"GET"}).retrieve().toEntity(String.class).block();
        HttpHeaders asHttpHeaders = response.getHeaders();
        Assertions.assertThat((String)((String)response.getBody())).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)asHttpHeaders.getAccessControlAllowOrigin()).as("Missing header value in response: Access-Control-Allow-Origin", new Object[0])).isEqualTo("*");
        ((ListAssert)Assertions.assertThat((List)asHttpHeaders.getAccessControlAllowMethods()).as("Missing header value in response: Access-Control-Allow-Methods", new Object[0])).isEqualTo(List.of(HttpMethod.GET));
        ((ObjectAssert)Assertions.assertThat((Object)response.getStatusCode()).as("Pre Flight call failed.", new Object[0])).isEqualTo((Object)HttpStatus.OK);
    }

    @Test
    public void testCorsRequestNotHandledByGW() {
        ResponseEntity responseEntity = (ResponseEntity)this.webClient.get().uri("/abc/123/function", new Object[0]).header("Origin", new String[]{"domain.com"}).header("Host", new String[]{"www.path.org"}).retrieve().onStatus(HttpStatusCode::isError, t -> Mono.empty()).toEntity(String.class).block();
        HttpHeaders asHttpHeaders = responseEntity.getHeaders();
        Assertions.assertThat((String)((String)responseEntity.getBody())).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)asHttpHeaders.getAccessControlAllowOrigin()).as("Missing header value in response: Access-Control-Allow-Origin", new Object[0])).isEqualTo("*");
        ((ObjectAssert)Assertions.assertThat((Object)responseEntity.getStatusCode()).as("CORS request failed.", new Object[0])).isEqualTo((Object)HttpStatus.NOT_FOUND);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @AutoConfigureBefore(value={GatewayAutoConfiguration.class})
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

