/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.discovery;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.config.GatewayLoadBalancerProperties;
import org.springframework.cloud.gateway.discovery.DiscoveryClientRouteDefinitionLocator;

public class ReactiveGatewayDiscoveryClientAutoConfigurationTests {

    @SpringBootConfiguration
    @EnableAutoConfiguration
    protected static class Config {
        protected Config() {
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class})
    public class DisabledByDefault {
        @Autowired(required=false)
        private DiscoveryClientRouteDefinitionLocator locator;

        @Test
        public void routeLocatorBeanMissing() {
            ((ObjectAssert)Assertions.assertThat((Object)this.locator).as("DiscoveryClientRouteDefinitionLocator exists", new Object[0])).isNull();
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.discovery.locator.enabled=true", "spring.cloud.gateway.loadbalancer.use404=true", "spring.cloud.discovery.client.simple.instances.service[0].uri=https://service1:443"})
    public class EnabledByProperty {
        @Autowired(required=false)
        private DiscoveryClientRouteDefinitionLocator locator;
        @Autowired(required=false)
        private GatewayLoadBalancerProperties properties;

        @Test
        public void routeLocatorBeanExists() {
            ((ObjectAssert)Assertions.assertThat((Object)this.locator).as("DiscoveryClientRouteDefinitionLocator was null", new Object[0])).isNotNull();
            List definitions = (List)this.locator.getRouteDefinitions().collectList().block();
            Assertions.assertThat((List)definitions).hasSize(1);
        }

        @Test
        public void use404() {
            Assertions.assertThat((boolean)this.properties.isUse404()).isTrue();
        }
    }
}

