/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.LoadBalancerServiceInstanceCookieFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpCookie;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class LoadBalancerServiceInstanceCookieFilterTests {
    private final LoadBalancerProperties properties = new LoadBalancerProperties();
    private final GatewayFilterChain chain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
    private final ServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).build());
    private final LoadBalancerServiceInstanceCookieFilter filter = new LoadBalancerServiceInstanceCookieFilter(this.properties);

    LoadBalancerServiceInstanceCookieFilterTests() {
    }

    @BeforeEach
    void setUp() {
        this.properties.getStickySession().setAddServiceInstanceCookie(true);
    }

    @Test
    void shouldAddServiceInstanceCookieHeader() {
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR, new DefaultResponse((ServiceInstance)new DefaultServiceInstance("test-01", "test", "host", 8080, false)));
        ServerWebExchange filteredExchange = this.testFilter(this.exchange);
        Assertions.assertThat((List)filteredExchange.getRequest().getHeaders().get((Object)"Cookie")).hasSize(1);
        Assertions.assertThat((List)filteredExchange.getRequest().getHeaders().get((Object)"Cookie")).containsExactly((Object[])new String[]{"sc-lb-instance-id=test-01"});
    }

    @Test
    void shouldAppendServiceInstanceCookieHeaderIfCookiesPresent() {
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).cookie(new HttpCookie[]{new HttpCookie("testCookieName", "testCookieValue")}).build());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR, new DefaultResponse((ServiceInstance)new DefaultServiceInstance("test-01", "test", "host", 8080, false)));
        ServerWebExchange filteredExchange = this.testFilter((ServerWebExchange)exchange);
        Assertions.assertThat((List)filteredExchange.getRequest().getHeaders().get((Object)"Cookie")).containsExactly((Object[])new String[]{"testCookieName=testCookieValue", "sc-lb-instance-id=test-01"});
    }

    @Test
    void shouldContinueChainWhenNoServiceInstanceResponse() {
        ServerWebExchange filteredExchange = this.testFilter(this.exchange);
        Assertions.assertThat((Map)filteredExchange.getRequest().getHeaders()).isEmpty();
    }

    @Test
    void shouldContinueChainWhenNullServiceInstanceCookieName() {
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR, new DefaultResponse((ServiceInstance)new DefaultServiceInstance("test-01", "test", "host", 8080, false)));
        this.properties.getStickySession().setInstanceIdCookieName(null);
        ServerWebExchange filteredExchange = this.testFilter(this.exchange);
        Assertions.assertThat((Map)filteredExchange.getRequest().getHeaders()).isEmpty();
    }

    @Test
    void shouldContinueChainWhenEmptyServiceInstanceCookieName() {
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR, new DefaultResponse((ServiceInstance)new DefaultServiceInstance("test-01", "test", "host", 8080, false)));
        this.properties.getStickySession().setInstanceIdCookieName("");
        ServerWebExchange filteredExchange = this.testFilter(this.exchange);
        Assertions.assertThat((Map)filteredExchange.getRequest().getHeaders()).isEmpty();
    }

    private ServerWebExchange testFilter(ServerWebExchange exchange) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)this.chain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        this.filter.filter(exchange, this.chain).block();
        ((GatewayFilterChain)Mockito.verify((Object)this.chain)).filter((ServerWebExchange)ArgumentMatchers.any(ServerWebExchange.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
        return (ServerWebExchange)captor.getValue();
    }
}

