/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.util.TestSocketUtils;
import org.springframework.test.web.reactive.server.WebTestClient;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
class NettyRoutingFilterTests
extends BaseWebClientTests {
    private static int port;
    @Autowired
    private ApplicationContext context;

    NettyRoutingFilterTests() {
    }

    @BeforeAll
    public static void beforeAll() {
        port = TestSocketUtils.findAvailableTcpPort();
    }

    @Test
    @Disabled
    void mockServerWorks() {
        WebTestClient client = WebTestClient.bindToApplicationContext((ApplicationContext)this.context).build();
        client.get().uri("/mockexample", new Object[0]).exchange().expectStatus().value(Matchers.lessThan((Comparable)Integer.valueOf(500)));
    }

    @Test
    void testCaseInsensitiveScheme() {
        DisposableServer server = HttpServer.create().port(port).host("127.0.0.1").route(routes -> routes.get("/issue", (request, response) -> response.sendString((Publisher)Mono.just((Object)"issue2207")))).bindNow();
        try {
            this.testClient.get().uri("/issue", new Object[0]).exchange().expectStatus().isOk().expectBody().consumeWith(entityExchangeResult -> {
                Assertions.assertThat((Object)entityExchangeResult).isNotNull();
                Assertions.assertThat((byte[])((byte[])entityExchangeResult.getResponseBody())).isNotNull();
                String content = new String((byte[])entityExchangeResult.getResponseBody());
                Assertions.assertThat((String)content).isEqualTo("issue2207");
            });
        }
        finally {
            server.disposeNow();
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    @Import(value={PermitAllSecurityConfiguration.class})
    public static class TestConfig {
        @Bean
        public RouteLocator routes(RouteLocatorBuilder builder) {
            return builder.routes().route(p -> p.path(new String[]{"/mockexample"}).filters(f -> f.prefixPath("/httpbin")).uri("http://example.com")).route(p -> p.path(new String[]{"/issue"}).uri("HTTP://127.0.0.1:" + port)).build();
        }
    }
}

