/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class RemoveJsonAttributesResponseBodyGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void removeJsonAttributeRootWorks() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.removejsonattributes.org"})).header("Content-Type", new String[]{"application/json"})).header("foo", new String[]{"test"})).header("bar", new String[]{"test"})).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map response = (Map)result.getResponseBody();
            Assertions.assertThat((Map)response).isNotNull();
            String responseBody = (String)response.get("data");
            Assertions.assertThat((String)responseBody).isNull();
            Map<String, Object> headers = TestUtils.getMap(response, "headers");
            Assertions.assertThat(headers).containsKey((Object)"user-agent");
        });
    }

    @Test
    public void removeJsonAttributeRecursivelyWorks() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.removejsonattributesrecursively.org"})).header("Content-Type", new String[]{"application/json"})).header("foo", new String[]{"test"})).header("bar", new String[]{"test"})).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map response = (Map)result.getResponseBody();
            Assertions.assertThat((Map)response).isNotNull();
            Map<String, Object> headers = TestUtils.getMap(response, "headers");
            Assertions.assertThat(headers).doesNotContainKey((Object)"foo");
            Assertions.assertThat(headers).containsEntry((Object)"bar", (Object)"test");
        });
    }

    @Test
    public void removeJsonAttributeNoMatchesWorks() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.removejsonattributesnomatches.org"})).header("Content-Type", new String[]{"application/json"})).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map response = (Map)result.getResponseBody();
            Assertions.assertThat((Map)response).isNotNull();
            Map<String, Object> headers = TestUtils.getMap(response, "headers");
            Assertions.assertThat(headers).isNotNull();
            Assertions.assertThat(headers).containsEntry((Object)"Content-Type", (Object)"application/json");
        });
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("remove_json_attributes_root_level_java_test", r -> r.path(new String[]{"/post"}).and().host(new String[]{"{sub}.removejsonattributes.org"}).filters(f -> f.removeJsonAttributes(false, new String[]{"data", "foo"})).uri(this.uri)).route("remove_json_attributes_recursively_java_test", r -> r.path(new String[]{"/post"}).and().host(new String[]{"{sub}.removejsonattributesrecursively.org"}).filters(f -> f.removeJsonAttributes(true, new String[]{"foo"})).uri(this.uri)).route("remove_json_attributes_no_matches_java_test", r -> r.path(new String[]{"/post"}).and().host(new String[]{"{sub}.removejsonattributesnomatches.org"}).filters(f -> f.removeJsonAttributes(new String[]{"test"})).uri(this.uri)).build();
        }
    }
}

