/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.RequestSizeGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.unit.DataSize;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class RequestSizeGatewayFilterFactoryTest
extends BaseWebClientTests {
    private static final String responseMesssage = "Request size is larger than permissible limit. Request size is . . where permissible limit is .*";

    @Test
    public void setRequestSizeFilterWorks() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.setrequestsize.org"})).header("content-length", new String[]{"6"})).bodyValue((Object)"123456").exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE).expectHeader().valueMatches("errorMessage", responseMesssage);
    }

    @Test
    public void toStringFormat() {
        RequestSizeGatewayFilterFactory.RequestSizeConfig config = new RequestSizeGatewayFilterFactory.RequestSizeConfig();
        config.setMaxSize(DataSize.ofBytes((long)1000L));
        GatewayFilter filter = new RequestSizeGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"max"})).contains(new CharSequence[]{"1000"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_request_size", r -> r.order(-1).host(new String[]{"**.setrequestsize.org"}).filters(f -> f.setRequestSize(Long.valueOf(5L))).uri(this.uri)).build();
        }
    }
}

