/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersProperties;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class SecureHeadersGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void secureHeadersFilterWorks() {
        Mono result = this.webClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.secureheaders.org"}).exchangeToMono(Mono::just);
        SecureHeadersProperties defaults = new SecureHeadersProperties();
        StepVerifier.create((Publisher)result).consumeNextWith(response -> {
            TestUtils.assertStatus(response, (HttpStatusCode)HttpStatus.OK);
            HttpHeaders httpHeaders = response.headers().asHttpHeaders();
            Assertions.assertThat((String)httpHeaders.getFirst("Strict-Transport-Security")).isEqualTo(defaults.getStrictTransportSecurity());
            Assertions.assertThat((String)httpHeaders.getFirst("X-Frame-Options")).isEqualTo(defaults.getFrameOptions());
            Assertions.assertThat((String)httpHeaders.getFirst("X-Content-Type-Options")).isEqualTo(defaults.getContentTypeOptions());
            Assertions.assertThat((String)httpHeaders.getFirst("Referrer-Policy")).isEqualTo(defaults.getReferrerPolicy());
            Assertions.assertThat((String)httpHeaders.getFirst("Content-Security-Policy")).isEqualTo(defaults.getContentSecurityPolicy());
            Assertions.assertThat((String)httpHeaders.getFirst("X-Download-Options")).isEqualTo(defaults.getDownloadOptions());
            Assertions.assertThat((String)httpHeaders.getFirst("X-Permitted-Cross-Domain-Policies")).isEqualTo(defaults.getPermittedCrossDomainPolicies());
        }).expectComplete().verify(DURATION);
    }

    @Test
    public void addsSecureHeadersAfterResponseIsReceived() {
        Mono responseEntity = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.patch().uri("/headers", new Object[0])).header("Host", new String[]{"www.secureheaders.org"})).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)"{ \"X-Frame-Options\": \"sameorigin\" }").retrieve().toEntity(String.class);
        StepVerifier.create((Publisher)responseEntity).consumeNextWith(response -> {
            Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
            Assertions.assertThat((List)response.getHeaders().get((Object)"X-Frame-Options")).containsOnly((Object[])new String[]{"sameorigin"});
        }).expectComplete().verify(DURATION);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

