/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class SetPathGatewayFilterFactoryIntegrationTests
extends BaseWebClientTests {
    @Test
    public void setPathFilterDefaultValuesWork() {
        this.testClient.get().uri("/foo/get", new Object[0]).header("Host", new String[]{"www.setpath.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"set_path_test"});
    }

    @Test
    public void setPathViaHostFilterWork() {
        this.testClient.get().uri("/", new Object[0]).header("Host", new String[]{"get.setpathhost.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"set_path_host_test"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

