/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.SetPathGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SetPathGatewayFilterFactoryTests {
    @Test
    public void setPathFilterWorks() {
        HashMap<String, String> variables = new HashMap<String, String>();
        this.testFilter("/baz/bar", "/baz/bar", variables);
    }

    @Test
    public void setEncodedPathFilterWorks() {
        HashMap<String, String> variables = new HashMap<String, String>();
        this.testFilter("/baz/foo%20bar", "/baz/foo%20bar", variables);
    }

    @Test
    public void setPathFilterWithTemplateVarsWorks() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", "123");
        this.testFilter("/bar/baz/{id}", "/bar/baz/123", variables);
    }

    @Test
    public void setPathFilterWithTemplatePrefixVarsWorks() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("org", "123");
        variables.put("scope", "abc");
        this.testFilter("/{org}/{scope}/function", "/123/abc/function", variables);
    }

    @Test
    public void setPathFilterWithEncodedCharactersWorks() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", "12 3");
        this.testFilter("/bar/baz/{id}", "/bar/baz/12 3", variables);
    }

    private void testFilter(String template, String expectedPath, HashMap<String, String> variables) {
        GatewayFilter filter = new SetPathGatewayFilterFactory().apply(c -> c.setTemplate(template));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        ServerWebExchangeUtils.putUriTemplateVariables((ServerWebExchange)exchange, variables);
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        filter.filter((ServerWebExchange)exchange, filterChain);
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        Assertions.assertThat((URI)webExchange.getRequest().getURI()).hasPath(expectedPath);
        LinkedHashSet uris = (LinkedHashSet)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        Assertions.assertThat((Collection)uris).contains((Object[])new URI[]{request.getURI()});
    }

    @Test
    public void toStringFormat() {
        SetPathGatewayFilterFactory.Config config = new SetPathGatewayFilterFactory.Config();
        config.setTemplate("mytemplate");
        GatewayFilter filter = new SetPathGatewayFilterFactory().apply(config);
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"mytemplate"});
    }
}

