/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class SetRequestHeaderGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void setRequestHeaderFilterWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.setrequestheader.org"}).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).doesNotContainEntry((Object)"X-Req-Foo", (Object)"First");
            Assertions.assertThat(headers).containsEntry((Object)"X-Req-Foo", (Object)"Second-www");
        });
    }

    @Test
    public void toStringFormat() {
        AbstractNameValueGatewayFilterFactory.NameValueConfig config = new AbstractNameValueGatewayFilterFactory.NameValueConfig().setName("myname").setValue("myvalue");
        GatewayFilter filter = new SetRequestHeaderGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"})).contains(new CharSequence[]{"myvalue"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_set_request_header", r -> r.order(-1).host(new String[]{"{sub}.setrequestheader.org"}).filters(f -> f.prefixPath("/httpbin").addRequestHeader("X-Req-Foo", "First").setRequestHeader("X-Req-Foo", "Second-{sub}")).uri(this.uri)).build();
        }
    }
}

