/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManager;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.util.MultiValueMap;

class ResponseCacheGatewayFilterTest {
    ResponseCacheManager cacheManagerToTest = new ResponseCacheManager(null, null, null, null);

    ResponseCacheGatewayFilterTest() {
    }

    @Test
    void requestShouldBeCacheable() {
        String uri = "http://test.com";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Cache-Control", "no-transform");
        MockServerHttpRequest request = MockServerHttpRequest.get((String)uri, (Object[])new Object[0]).headers((MultiValueMap)httpHeaders).build();
        Assertions.assertThat((boolean)this.cacheManagerToTest.isRequestCacheable((ServerHttpRequest)request)).isTrue();
    }

    @Test
    void requestShouldNotBeCacheable() {
        String uri = "http://test.com";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Cache-Control", "no-store");
        MockServerHttpRequest request = MockServerHttpRequest.get((String)uri, (Object[])new Object[0]).headers((MultiValueMap)httpHeaders).build();
        Assertions.assertThat((boolean)this.cacheManagerToTest.isRequestCacheable((ServerHttpRequest)request)).isFalse();
        httpHeaders = new HttpHeaders();
        httpHeaders.add("Cache-Control", "no-transform");
        request = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)uri, (Object[])new Object[0]).headers((MultiValueMap)httpHeaders)).build();
        Assertions.assertThat((boolean)this.cacheManagerToTest.isRequestCacheable((ServerHttpRequest)request)).isFalse();
    }

    @Test
    void responseShouldBeCacheable() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "public");
        MockServerHttpResponse response = new MockServerHttpResponse();
        response.getHeaders().putAll((Map)headers);
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        Assertions.assertThat((boolean)this.cacheManagerToTest.isResponseCacheable((ServerHttpResponse)response)).isTrue();
        headers = new HttpHeaders();
        headers.add("Cache-Control", "public");
        response = new MockServerHttpResponse();
        response.getHeaders().putAll((Map)headers);
        response.setStatusCode((HttpStatusCode)HttpStatus.PARTIAL_CONTENT);
        Assertions.assertThat((boolean)this.cacheManagerToTest.isResponseCacheable((ServerHttpResponse)response)).isTrue();
    }

    @Test
    void responseShouldNotBeCacheable() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "public");
        MockServerHttpResponse response = new MockServerHttpResponse();
        response.getHeaders().putAll((Map)headers);
        response.setStatusCode((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS);
        Assertions.assertThat((boolean)this.cacheManagerToTest.isResponseCacheable((ServerHttpResponse)response)).isFalse();
        headers = new HttpHeaders();
        headers.add("Cache-Control", "private");
        response = new MockServerHttpResponse();
        response.getHeaders().putAll((Map)headers);
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        Assertions.assertThat((boolean)this.cacheManagerToTest.isResponseCacheable((ServerHttpResponse)response)).isFalse();
        headers = new HttpHeaders();
        headers.add("Cache-Control", "no-store");
        response = new MockServerHttpResponse();
        response.getHeaders().putAll((Map)headers);
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        Assertions.assertThat((boolean)this.cacheManagerToTest.isResponseCacheable((ServerHttpResponse)response)).isFalse();
    }
}

