/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.SetResponseHeadersAfterCacheExchangeMutator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

class SetResponseHeadersAfterCacheExchangeMutatorTest {
    private MockServerWebExchange inputExchange;

    SetResponseHeadersAfterCacheExchangeMutatorTest() {
    }

    @BeforeEach
    void setUp() {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setCacheControl("max-age=1234");
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).build();
        this.inputExchange = MockServerWebExchange.from((MockServerHttpRequest)httpRequest);
        MockServerHttpResponse httpResponse = this.inputExchange.getResponse();
        httpResponse.setStatusCode((HttpStatusCode)HttpStatus.OK);
        httpResponse.getHeaders().putAll((Map)responseHeaders);
    }

    @Test
    void headersFromCacheOverrideHeadersFromResponse() {
        SetResponseHeadersAfterCacheExchangeMutator toTest = new SetResponseHeadersAfterCacheExchangeMutator();
        this.inputExchange.getResponse().getHeaders().set("X-Header-1", "Value-original");
        CachedResponse cachedResponse = new CachedResponse.Builder((HttpStatusCode)HttpStatus.OK).header("X-Header-1", "Value-cached").build();
        toTest.accept((ServerWebExchange)this.inputExchange, cachedResponse);
        Assertions.assertThat((Map)this.inputExchange.getResponse().getHeaders()).containsEntry((Object)"X-Header-1", List.of("Value-cached"));
    }

    @Test
    void headersFromResponseAreDropped() {
        SetResponseHeadersAfterCacheExchangeMutator toTest = new SetResponseHeadersAfterCacheExchangeMutator();
        this.inputExchange.getResponse().getHeaders().set("X-Header-1", "Value-original");
        CachedResponse cachedResponse = new CachedResponse.Builder((HttpStatusCode)HttpStatus.OK).build();
        toTest.accept((ServerWebExchange)this.inputExchange, cachedResponse);
        Assertions.assertThat((Map)this.inputExchange.getResponse().getHeaders()).doesNotContainKey((Object)"X-Header-1");
    }
}

