/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.codec.max-in-memory-size=40"})
@DirtiesContext
public class ModifyResponseBodyGatewayFilterFactoryTests
extends BaseWebClientTests {
    private static final String toLarge;

    @Test
    public void testModificationOfResponseBody() {
        URI uri = UriComponentsBuilder.fromUriString((String)(this.baseUri + "/")).build(true).toUri();
        this.testClient.get().uri(uri).header("Host", new String[]{"www.modifyresponsebodyjava.org"}).accept(new MediaType[]{MediaType.APPLICATION_JSON}).exchange().expectBody().json("{\"value\": \"httpbin compatible home\", \"length\": 23}");
    }

    @Test
    public void modifyResponeBodyToLarge() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.modifyresponsebodyjavatoolarge.org"})).header("Content-Type", new String[]{"application/json"})).body(BodyInserters.fromValue((Object)toLarge)).exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).expectBody().jsonPath("message", new Object[0]).isEqualTo((Object)"Exceeded limit on max bytes to buffer : 40");
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            sb.append("to-large-");
        }
        toLarge = sb.toString();
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("modify_response_java_test", r -> r.path(new String[]{"/"}).and().host(new String[]{"www.modifyresponsebodyjava.org"}).filters(f -> f.prefixPath("/httpbin").modifyResponseBody(String.class, Map.class, (webExchange, originalResponse) -> {
                HashMap<String, Object> modifiedResponse = new HashMap<String, Object>();
                modifiedResponse.put("value", originalResponse);
                modifiedResponse.put("length", originalResponse.length());
                return Mono.just(modifiedResponse);
            })).uri(this.uri)).route("modify_response_java_test_to_large", r -> r.path(new String[]{"/"}).and().host(new String[]{"www.modifyresponsebodyjavatoolarge.org"}).filters(f -> f.prefixPath("/httpbin").modifyResponseBody(String.class, String.class, (webExchange, originalResponse) -> Mono.just((Object)toLarge))).uri(this.uri)).build();
        }
    }
}

