/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.propagation.Propagator;
import io.micrometer.tracing.test.simple.SimpleSpanBuilder;
import io.micrometer.tracing.test.simple.SimpleTracer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayContext;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayPropagatingSenderTracingObservationHandler;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

class GatewayPropagatingSenderTracingObservationHandlerTests {
    SimpleTracer tracer = new SimpleTracer();
    Propagator propagator = new Propagator(){

        public List<String> fields() {
            return Arrays.asList("foo", "bar");
        }

        public <C> void inject(TraceContext context, C carrier, Propagator.Setter<C> setter) {
        }

        public <C> Span.Builder extract(C carrier, Propagator.Getter<C> getter) {
            return new SimpleSpanBuilder(GatewayPropagatingSenderTracingObservationHandlerTests.this.tracer);
        }
    };
    GatewayPropagatingSenderTracingObservationHandler handler = new GatewayPropagatingSenderTracingObservationHandler((Tracer)this.tracer, this.propagator, Collections.singletonList("remote"));

    GatewayPropagatingSenderTracingObservationHandlerTests() {
    }

    @Test
    void shouldRemovePropagationFieldsFromTheRequestBeforePropagating() {
        HttpHeaders headers = new HttpHeaders();
        headers.put("foo", Collections.singletonList("foo value"));
        headers.put("bar", Collections.singletonList("bar value"));
        headers.put("baz", Collections.singletonList("baz value"));
        headers.put("remote", Collections.singletonList("remote value"));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"/get", (Object[])new Object[0]).build();
        MockServerWebExchange serverWebExchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        GatewayContext gatewayContext = new GatewayContext(headers, (ServerHttpRequest)request, (ServerWebExchange)serverWebExchange);
        this.handler.onStart(gatewayContext);
        ((MapAssert)((MapAssert)BDDAssertions.then((Map)headers).doesNotContainKeys((Object[])new String[]{"foo", "bar"})).containsEntry((Object)"baz", Collections.singletonList("baz value"))).containsEntry((Object)"remote", Collections.singletonList("remote value"));
    }
}

