/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.filter.ratelimit.RedisRateLimiter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest
@DirtiesContext
@ActiveProfiles(value={"redis-rate-limiter-config"})
public class RedisRateLimiterConfigTests {
    @Autowired
    private RedisRateLimiter rateLimiter;
    @Autowired
    private RouteLocator routeLocator;

    @BeforeEach
    public void init() {
        this.routeLocator.getRoutes().collectList().block();
    }

    @Test
    public void shouldThrowAnErrorWhenReplenishRateIsHigherThanBurstCapacity() {
        Assertions.assertThatThrownBy(() -> new RedisRateLimiter(10, 5)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void redisRateConfiguredFromEnvironment() {
        this.assertFilter("redis_rate_limiter_config_test", 10, 20, 1, false);
    }

    @Test
    public void redisRateConfiguredFromEnvironmentMinimal() {
        this.assertFilter("redis_rate_limiter_minimal_config_test", 2, 1, 1, false);
    }

    @Test
    public void redisRateConfiguredFromJavaAPI() {
        this.assertFilter("custom_redis_rate_limiter", 20, 40, 10, false);
    }

    @Test
    public void redisRateConfiguredFromJavaAPIDirectBean() {
        this.assertFilter("alt_custom_redis_rate_limiter", 30, 60, 20, true);
    }

    private void assertFilter(String key, int replenishRate, int burstCapacity, int requestedTokens, boolean useDefaultConfig) {
        RedisRateLimiter.Config config;
        if (useDefaultConfig) {
            config = this.rateLimiter.getDefaultConfig();
        } else {
            Assertions.assertThat((Map)this.rateLimiter.getConfig()).containsKey((Object)key);
            config = (RedisRateLimiter.Config)this.rateLimiter.getConfig().get(key);
        }
        Assertions.assertThat((Object)config).isNotNull();
        Assertions.assertThat((int)config.getReplenishRate()).isEqualTo(replenishRate);
        Assertions.assertThat((int)config.getBurstCapacity()).isEqualTo(burstCapacity);
        Assertions.assertThat((int)config.getRequestedTokens()).isEqualTo(requestedTokens);
        Route route = (Route)this.routeLocator.getRoutes().filter(r -> r.getId().equals(key)).next().block();
        Assertions.assertThat((Object)route).isNotNull();
        Assertions.assertThat((List)route.getFilters()).hasSize(1);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    public static class TestConfig {
        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("custom_redis_rate_limiter", r -> r.path(new String[]{"/custom"}).filters(f -> f.requestRateLimiter().rateLimiter(RedisRateLimiter.class, rl -> rl.setBurstCapacity(40).setReplenishRate(20).setRequestedTokens(10)).and()).uri("http://localhost")).route("alt_custom_redis_rate_limiter", r -> r.path(new String[]{"/custom"}).filters(f -> f.requestRateLimiter(c -> c.setRateLimiter((RateLimiter)this.myRateLimiter()))).uri("http://localhost")).build();
        }

        @Bean
        public RedisRateLimiter myRateLimiter() {
            return new RedisRateLimiter(30, 60, 20);
        }
    }
}

