/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import io.lettuce.core.RedisException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.filter.ratelimit.RedisRateLimiter;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import reactor.core.publisher.Mono;

@ExtendWith(value={MockitoExtension.class})
public class RedisRateLimiterUnitTests {
    private static final int DEFAULT_REPLENISH_RATE = 1;
    private static final int DEFAULT_BURST_CAPACITY = 1;
    public static final String ROUTE_ID = "routeId";
    public static final String REQUEST_ID = "id";
    public static final String[] CONFIGURATION_SERVICE_BEANS = new String[0];
    public static final RedisException REDIS_EXCEPTION = new RedisException("Mocked problem");
    @Mock
    private ApplicationContext applicationContext;
    @Mock
    private ReactiveStringRedisTemplate redisTemplate;
    private RedisRateLimiter redisRateLimiter;

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)((ReactiveStringRedisTemplate)this.applicationContext.getBean(ReactiveStringRedisTemplate.class))).thenReturn((Object)this.redisTemplate);
        Mockito.when((Object)this.applicationContext.getBeanNamesForType(ConfigurationService.class)).thenReturn((Object)CONFIGURATION_SERVICE_BEANS);
        this.redisRateLimiter = new RedisRateLimiter(1, 1);
    }

    @AfterEach
    public void tearDown() {
        Mockito.reset((Object[])new ApplicationContext[]{this.applicationContext});
    }

    @Test
    public void shouldThrowWhenNotInitialized() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.redisRateLimiter.isAllowed(ROUTE_ID, REQUEST_ID));
    }

    @Test
    public void shouldAllowRequestWhenRedisIssueOccurs() {
        Mockito.when((Object)this.redisTemplate.execute((RedisScript)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyList())).thenThrow(new Throwable[]{REDIS_EXCEPTION});
        this.redisRateLimiter.setApplicationContext(this.applicationContext);
        Mono response = this.redisRateLimiter.isAllowed(ROUTE_ID, REQUEST_ID);
        Assertions.assertThat((Object)((RateLimiter.Response)response.block())).extracting(RateLimiter.Response::isAllowed).isEqualTo((Object)true);
    }

    @Test
    public void shouldReturnHeadersWhenRedisIssueOccurs() {
        Mockito.when((Object)this.redisTemplate.execute((RedisScript)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyList())).thenThrow(new Throwable[]{REDIS_EXCEPTION});
        this.redisRateLimiter.setApplicationContext(this.applicationContext);
        Mono response = this.redisRateLimiter.isAllowed(ROUTE_ID, REQUEST_ID);
        Assertions.assertThat((Map)((RateLimiter.Response)response.block()).getHeaders()).containsOnly(new Map.Entry[]{MapEntry.entry((Object)this.redisRateLimiter.getRemainingHeader(), (Object)"-1"), MapEntry.entry((Object)this.redisRateLimiter.getBurstCapacityHeader(), (Object)"1"), MapEntry.entry((Object)this.redisRateLimiter.getReplenishRateHeader(), (Object)"1"), MapEntry.entry((Object)this.redisRateLimiter.getRequestedTokensHeader(), (Object)"1")});
    }
}

