/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.autoconfigure.web.reactive.AutoConfigureWebTestClient;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.util.TestSocketUtils;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.bind.annotation.RestController;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@AutoConfigureWebTestClient
public class RoutePredicateHandlerMappingWithAutoconfiguredClientIntegrationTests {
    @Autowired
    WebTestClient webTestClient;

    @BeforeAll
    static void beforeClass() {
        int managementPort = TestSocketUtils.findAvailableTcpPort();
        System.setProperty("management.server.port", String.valueOf(managementPort));
    }

    @AfterAll
    static void afterClass() {
        System.clearProperty("management.server.port");
    }

    @Test
    void shouldReturnOk() {
        this.webTestClient.get().uri("/get", new Object[0]).exchange().expectStatus().isOk();
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    @RestController
    public static class TestConfig {
        @Value(value="${test.uri:http://httpbin.org:80}")
        String uri;

        @Bean
        RouteLocator testRoutes(RouteLocatorBuilder builder) {
            return builder.routes().route(r -> r.path(new String[]{"/get"}).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

