/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.time.ZonedDateTime;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class BetweenRoutePredicateFactoryIntegrationTests
extends BaseWebClientTests {
    @Test
    public void betweenPredicateWithValidDates() {
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.betweenvalid.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"test_between_valid"});
    }

    @Test
    public void notBetweenPredicateWorks() {
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.notbetween.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"default_path_to_httpbin"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_between_valid", r -> r.host(new String[]{"**.betweenvalid.org"}).and().between(ZonedDateTime.now().minusDays(1L), ZonedDateTime.now().plusDays(1L)).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

