/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.handler.predicate.MethodRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class MethodRoutePredicateFactoryTests
extends BaseWebClientTests {
    @Test
    public void methodRouteWorks() {
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.method.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"method_test_get"});
    }

    @Test
    public void methodGetAndPostRouteWorks() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/multivalueheaders", new Object[0])).header("Host", new String[]{"www.method.org"})).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"method_test_get_and_post"});
        this.testClient.get().uri("/multivalueheaders", new Object[0]).header("Host", new String[]{"www.method.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"method_test_get_and_post"});
    }

    @Test
    public void methodRouteNotMatching() {
        this.testClient.delete().uri("/multivalueheaders", new Object[0]).header("Host", new String[]{"www.method.org"}).exchange().expectStatus().value(integer -> integer.equals(HttpStatus.METHOD_NOT_ALLOWED)).expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"default_path_to_httpbin"});
    }

    @Test
    public void toStringFormatSingleMethod() {
        MethodRoutePredicateFactory.Config config = new MethodRoutePredicateFactory.Config();
        config.setMethods(new HttpMethod[]{HttpMethod.GET});
        Predicate predicate = new MethodRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Methods: [GET]"});
    }

    @Test
    public void toStringFormatMultipleMethods() {
        MethodRoutePredicateFactory.Config config = new MethodRoutePredicateFactory.Config();
        config.setMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT});
        Predicate predicate = new MethodRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Methods: [GET, PUT]"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("method_test_get", r -> r.method(new String[]{"GET"}).and().path(new String[]{"/get"}).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).route("method_test_get_and_post", r -> r.method(new String[]{"GET", "POST"}).and().path(new String[]{"/multivalueheaders"}).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

