/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.time.Duration;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.handler.predicate.RemoteAddrRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.support.ipresolver.RemoteAddressResolver;
import org.springframework.cloud.gateway.support.ipresolver.XForwardedRemoteAddressResolver;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(value={"remote-address"})
public class RemoteAddrRoutePredicateFactoryTests
extends BaseWebClientTests {
    @Test
    public void remoteAddrWorks() {
        Mono result = this.webClient.get().uri("/ok/httpbin/", new Object[0]).exchangeToMono(Mono::just);
        StepVerifier.create((Publisher)result).consumeNextWith(response -> TestUtils.assertStatus(response, (HttpStatusCode)HttpStatus.OK)).expectComplete().verify(DURATION);
    }

    @Test
    public void remoteAddrRejects() {
        Mono result = this.webClient.get().uri("/nok/httpbin/", new Object[0]).exchangeToMono(Mono::just);
        StepVerifier.create((Publisher)result).consumeNextWith(response -> TestUtils.assertStatus(response, (HttpStatusCode)HttpStatus.NOT_FOUND)).expectComplete().verify(DURATION);
    }

    @Test
    public void remoteAddrWorksWithXForwardedRemoteAddress() {
        Mono result = this.webClient.get().uri("/xforwardfor", new Object[0]).header("X-Forwarded-For", new String[]{"12.34.56.78"}).exchangeToMono(Mono::just);
        StepVerifier.create((Publisher)result).consumeNextWith(response -> TestUtils.assertStatus(response, (HttpStatusCode)HttpStatus.OK)).expectComplete().verify(Duration.ofSeconds(20L));
    }

    @Test
    public void toStringFormat() {
        RemoteAddrRoutePredicateFactory.Config config = new RemoteAddrRoutePredicateFactory.Config();
        config.setSources(new String[]{"1.2.3.4", "5.6.7.8"});
        Predicate predicate = new RemoteAddrRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"RemoteAddrs: [1.2.3.4, 5.6.7.8]"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("x_forwarded_for_test", r -> r.path(new String[]{"/xforwardfor"}).and().remoteAddr((RemoteAddressResolver)XForwardedRemoteAddressResolver.maxTrustedIndex((int)1), new String[]{"12.34.56.78"}).filters(f -> f.setStatus(200)).uri(this.uri)).build();
        }
    }
}

