/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.WeightCalculatorWebFilter;
import org.springframework.cloud.gateway.handler.predicate.WeightRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.support.WeightConfig;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class WeightRoutePredicateFactoryIntegrationTests
extends BaseWebClientTests {
    @Autowired
    private WeightCalculatorWebFilter filter;

    private static Supplier<Double> getRandom(double value) {
        Supplier random = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)((Double)random.get())).thenReturn((Object)value);
        return random;
    }

    @Test
    public void highWeight() {
        this.filter.setRandomSupplier(WeightRoutePredicateFactoryIntegrationTests.getRandom(0.9));
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.weighthigh.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"weight_high_test"});
    }

    @Test
    public void lowWeight() {
        this.filter.setRandomSupplier(WeightRoutePredicateFactoryIntegrationTests.getRandom(0.1));
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.weightlow.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"weight_low_test"});
    }

    @Test
    public void toStringFormat() {
        WeightConfig config = new WeightConfig("mygroup", "myroute", 5);
        Predicate predicate = new WeightRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Weight: mygroup 5"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        private String uri;

        public TestConfig(WeightCalculatorWebFilter filter) {
            Supplier<Double> random = WeightRoutePredicateFactoryIntegrationTests.getRandom(0.4);
            filter.setRandomSupplier(random);
        }

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("weight_low_test", r -> r.weight("group1", 2).and().host(new String[]{"**.weightlow.org"}).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

