/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.time.Duration;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.route.InMemoryRouteDefinitionRepository;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.support.NotFoundException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class InMemoryRouteDefinitionRepositoryTests {
    private InMemoryRouteDefinitionRepository repository;

    @BeforeEach
    public void setUp() throws Exception {
        this.repository = new InMemoryRouteDefinitionRepository();
    }

    @Test
    public void shouldProtectRoutesAgainstConcurrentModificationException() {
        Flux createRoutes = Flux.just((Object[])new Mono[]{this.createRoute("foo1"), this.createRoute("foo2"), this.createRoute("foo3")}).flatMap(arg_0 -> ((InMemoryRouteDefinitionRepository)this.repository).save(arg_0));
        StepVerifier.create((Publisher)createRoutes).verifyComplete();
        Flux readRoutesWithDelay = this.repository.getRouteDefinitions().delayElements(Duration.ofMillis(100L));
        Mono createAnotherRoute = this.repository.save(this.createRoute("bar"));
        StepVerifier.withVirtualTime(() -> readRoutesWithDelay).expectSubscription().expectNextCount(1L).then(() -> ((Mono)createAnotherRoute).subscribe()).thenAwait().expectNextCount(2L).verifyComplete();
    }

    @Test
    public void shouldValidateRouteIdOnCreate() {
        Mono emptyRoute = Mono.just((Object)new RouteDefinition());
        StepVerifier.create((Publisher)this.repository.save(emptyRoute)).verifyError(IllegalArgumentException.class);
    }

    @Test
    public void shouldCreateRoute() {
        StepVerifier.create((Publisher)this.repository.save(this.createRoute("foo"))).verifyComplete();
        StepVerifier.create((Publisher)this.repository.getRouteDefinitions()).expectNextCount(1L).verifyComplete();
    }

    @Test
    public void shouldDeleteRoute() {
        Flux createRoutes = Flux.just((Object[])new Mono[]{this.createRoute("foo1"), this.createRoute("foo2"), this.createRoute("foo3")}).flatMap(arg_0 -> ((InMemoryRouteDefinitionRepository)this.repository).save(arg_0));
        StepVerifier.create((Publisher)createRoutes).verifyComplete();
        Mono deleteRoute = this.repository.delete(Mono.just((Object)"foo2"));
        StepVerifier.create((Publisher)deleteRoute).verifyComplete();
        StepVerifier.create((Publisher)this.repository.getRouteDefinitions()).expectNextCount(2L).verifyComplete();
    }

    @Test
    public void shouldThrownNotFoundWhenDeleteInvalidRoute() {
        StepVerifier.create((Publisher)this.repository.delete(Mono.just((Object)"x"))).verifyError(NotFoundException.class);
    }

    private Mono<RouteDefinition> createRoute(String id) {
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setId(id);
        return Mono.just((Object)routeDefinition);
    }
}

