/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@SpringBootTest(properties={"spring.cloud.gateway.restrictive-property-accessor.enabled=false"})
public class ShortcutConfigurableNonRestrictiveTests {
    @Autowired
    BeanFactory beanFactory;
    @Autowired
    ConfigurableEnvironment env;
    private SpelExpressionParser parser;

    @Test
    public void testNormalizeDefaultTypeWithSpelAndPropertyReferenceEnabled() {
        this.parser = new SpelExpressionParser();
        ShortcutConfigurable shortcutConfigurable = new ShortcutConfigurable(){

            public List<String> shortcutFieldOrder() {
                return Arrays.asList("bean", "arg1");
            }
        };
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("barproperty", "#{@bar.getInt}");
        args.put("arg1", "val1");
        Map map = ShortcutConfigurable.ShortcutType.DEFAULT.normalize(args, shortcutConfigurable, this.parser, this.beanFactory);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)map).isNotNull()).containsEntry((Object)"barproperty", (Object)42)).containsEntry((Object)"arg1", (Object)"val1");
    }

    @Test
    public void testNormalizeDefaultTypeWithSpelAndMethodReferenceEnabled() {
        this.parser = new SpelExpressionParser();
        ShortcutConfigurable shortcutConfigurable = new ShortcutConfigurable(){

            public List<String> shortcutFieldOrder() {
                return Arrays.asList("bean", "arg1");
            }
        };
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("barmethod", "#{@bar.myMethod}");
        args.put("arg1", "val1");
        Map map = ShortcutConfigurable.ShortcutType.DEFAULT.normalize(args, shortcutConfigurable, this.parser, this.beanFactory);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)map).isNotNull()).containsEntry((Object)"barmethod", (Object)42)).containsEntry((Object)"arg1", (Object)"val1");
    }

    protected static class Bar {
        protected Bar() {
        }

        public int getInt() {
            return 42;
        }

        public int myMethod() {
            return 42;
        }
    }

    @SpringBootConfiguration
    protected static class TestConfig {
        protected TestConfig() {
        }

        @Bean
        public Integer foo() {
            return 42;
        }

        @Bean
        public Bar bar() {
            return new Bar();
        }
    }
}

