/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.ipresolver;

import java.net.InetSocketAddress;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.support.ipresolver.XForwardedRemoteAddressResolver;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class XForwardedRemoteAddressResolverTest {
    private final InetSocketAddress remote0000Address = InetSocketAddress.createUnresolved("0.0.0.0", 1234);
    private final XForwardedRemoteAddressResolver trustOne = XForwardedRemoteAddressResolver.maxTrustedIndex((int)1);
    private final XForwardedRemoteAddressResolver trustAll = XForwardedRemoteAddressResolver.trustAll();

    @Test
    public void maxIndexOneReturnsLastForwardedIp() {
        ServerWebExchange exchange = this.buildExchange(this.oneTwoThreeBuilder());
        InetSocketAddress address = this.trustOne.resolve(exchange);
        Assertions.assertThat((String)address.getHostName()).isEqualTo("0.0.0.3");
    }

    @Test
    public void maxIndexOneFallsBackToRemoteIp() {
        ServerWebExchange exchange = this.buildExchange(this.remoteAddressOnlyBuilder());
        InetSocketAddress address = this.trustOne.resolve(exchange);
        Assertions.assertThat((String)address.getHostName()).isEqualTo("0.0.0.0");
    }

    @Test
    public void maxIndexOneReturnsNullIfNoForwardedOrRemoteIp() {
        ServerWebExchange exchange = this.buildExchange(this.emptyBuilder());
        InetSocketAddress address = this.trustOne.resolve(exchange);
        Assertions.assertThat((Object)address).isEqualTo(null);
    }

    @Test
    public void trustOneFallsBackOnEmptyHeader() {
        ServerWebExchange exchange = this.buildExchange(this.remoteAddressOnlyBuilder().header("X-Forwarded-For", new String[]{""}));
        InetSocketAddress address = this.trustOne.resolve(exchange);
        Assertions.assertThat((String)address.getHostName()).isEqualTo("0.0.0.0");
    }

    @Test
    public void trustOneFallsBackOnMultipleHeaders() {
        ServerWebExchange exchange = this.buildExchange(this.remoteAddressOnlyBuilder().header("X-Forwarded-For", new String[]{"0.0.0.1"}).header("X-Forwarded-For", new String[]{"0.0.0.2"}));
        InetSocketAddress address = this.trustOne.resolve(exchange);
        Assertions.assertThat((String)address.getHostName()).isEqualTo("0.0.0.0");
    }

    @Test
    public void trustAllReturnsFirstForwardedIp() {
        ServerWebExchange exchange = this.buildExchange(this.oneTwoThreeBuilder());
        InetSocketAddress address = this.trustAll.resolve(exchange);
        Assertions.assertThat((String)address.getHostName()).isEqualTo("0.0.0.1");
    }

    @Test
    public void trustAllFinalFallsBackToRemoteIp() {
        ServerWebExchange exchange = this.buildExchange(this.remoteAddressOnlyBuilder());
        InetSocketAddress address = this.trustAll.resolve(exchange);
        Assertions.assertThat((String)address.getHostName()).isEqualTo("0.0.0.0");
    }

    @Test
    public void trustAllReturnsNullIfNoForwardedOrRemoteIp() {
        ServerWebExchange exchange = this.buildExchange(this.emptyBuilder());
        InetSocketAddress address = this.trustAll.resolve(exchange);
        Assertions.assertThat((Object)address).isEqualTo(null);
    }

    @Test
    public void trustAllFallsBackOnEmptyHeader() {
        ServerWebExchange exchange = this.buildExchange(this.remoteAddressOnlyBuilder().header("X-Forwarded-For", new String[]{""}));
        InetSocketAddress address = this.trustAll.resolve(exchange);
        Assertions.assertThat((String)address.getHostName()).isEqualTo("0.0.0.0");
    }

    @Test
    public void trustAllFallsBackOnMultipleHeaders() {
        ServerWebExchange exchange = this.buildExchange(this.remoteAddressOnlyBuilder().header("X-Forwarded-For", new String[]{"0.0.0.1"}).header("X-Forwarded-For", new String[]{"0.0.0.2"}));
        InetSocketAddress address = this.trustAll.resolve(exchange);
        Assertions.assertThat((String)address.getHostName()).isEqualTo("0.0.0.0");
    }

    private MockServerHttpRequest.BaseBuilder emptyBuilder() {
        return MockServerHttpRequest.get((String)"someUrl", (Object[])new Object[0]);
    }

    private MockServerHttpRequest.BaseBuilder remoteAddressOnlyBuilder() {
        return MockServerHttpRequest.get((String)"someUrl", (Object[])new Object[0]).remoteAddress(this.remote0000Address);
    }

    private MockServerHttpRequest.BaseBuilder oneTwoThreeBuilder() {
        return MockServerHttpRequest.get((String)"someUrl", (Object[])new Object[0]).remoteAddress(this.remote0000Address).header("X-Forwarded-For", new String[]{"0.0.0.1,0.0.0.2, 0.0.0.3"});
    }

    private ServerWebExchange buildExchange(MockServerHttpRequest.BaseBuilder requestBuilder) {
        return MockServerWebExchange.from((MockServerHttpRequest)requestBuilder.build());
    }
}

