/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.tagsprovider;

import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.handler.predicate.HostRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.MethodRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayPathTagsProvider;
import org.springframework.http.HttpMethod;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class GatewayPathTagsProviderTests {
    private final GatewayPathTagsProvider pathTagsProvider = new GatewayPathTagsProvider();
    private static final String ROUTE_URI = "http://gatewaytagsprovider.org:80";

    @Test
    void addPathToRoutes() {
        List<String> pathList = Collections.singletonList("/git/**");
        PathRoutePredicateFactory.Config pathConfig = new PathRoutePredicateFactory.Config().setPatterns(pathList);
        HostRoutePredicateFactory.Config hostConfig = new HostRoutePredicateFactory.Config().setPatterns(Collections.singletonList("**.myhost.com"));
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("git")).uri(ROUTE_URI)).predicate(new PathRoutePredicateFactory().apply(pathConfig).and(new HostRoutePredicateFactory().apply(hostConfig))).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)ROUTE_URI, (Object[])new Object[0]).build());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, route);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_MATCHED_PATH_ATTR, pathList.get(0));
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_MATCHED_PATH_ROUTE_ID_ATTR, route.getId());
        Tags tags = this.pathTagsProvider.apply((ServerWebExchange)exchange);
        Assertions.assertThat((long)tags.stream().count()).isEqualTo(1L);
        Assertions.assertThat((boolean)tags.stream().anyMatch(tag -> "path".equals(tag.getKey()) && tag.getValue().equals(pathList.get(0)))).isEqualTo(true);
    }

    @Test
    void addsMultiplePathToRoutes() {
        List<String> pathList = Collections.singletonList("/git/**");
        List<String> pathList2 = Collections.singletonList("/git2/**");
        PathRoutePredicateFactory.Config pathConfig = new PathRoutePredicateFactory.Config().setPatterns(pathList);
        PathRoutePredicateFactory.Config pathConfig2 = new PathRoutePredicateFactory.Config().setPatterns(pathList2);
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("git")).uri(ROUTE_URI)).predicate(new PathRoutePredicateFactory().apply(pathConfig).or(new PathRoutePredicateFactory().apply(pathConfig2))).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)ROUTE_URI, (Object[])new Object[0]).build());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, route);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_MATCHED_PATH_ATTR, pathList2.get(0));
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_MATCHED_PATH_ROUTE_ID_ATTR, route.getId());
        Tags tags = this.pathTagsProvider.apply((ServerWebExchange)exchange);
        Assertions.assertThat((long)tags.stream().count()).isEqualTo(1L);
        Assertions.assertThat((boolean)tags.stream().anyMatch(tag -> "path".equals(tag.getKey()) && tag.getValue().equals(pathList2.get(0)))).isEqualTo(true);
    }

    @Test
    void ignoreRoutesWithoutPath() {
        MethodRoutePredicateFactory.Config config = new MethodRoutePredicateFactory.Config();
        config.setMethods(new HttpMethod[]{HttpMethod.GET});
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("empty")).uri(ROUTE_URI)).predicate(new MethodRoutePredicateFactory().apply(config)).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)ROUTE_URI, (Object[])new Object[0]).build());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, route);
        Tags tags = this.pathTagsProvider.apply((ServerWebExchange)exchange);
        Assertions.assertThat((long)tags.stream().count()).isEqualTo(0L);
    }
}

