/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/httpbin"})
public class HttpBinCompatibleController {
    private static final Log log = LogFactory.getLog(HttpBinCompatibleController.class);
    private static final String HEADER_REQ_VARY = "X-Request-Vary";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @GetMapping(value={"/"})
    public String home() {
        return "httpbin compatible home";
    }

    @RequestMapping(path={"/headers"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> headers(ServerWebExchange exchange) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("headers", this.getHeaders(exchange));
        return result;
    }

    @PatchMapping(value={"/headers"})
    public ResponseEntity<Map<String, Object>> headersPatch(ServerWebExchange exchange, @RequestBody Map<String, String> headersToAdd) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        result.put("headers", this.getHeaders(exchange));
        ResponseEntity.BodyBuilder responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.OK);
        headersToAdd.forEach((x$0, xva$1) -> {
            ResponseEntity.BodyBuilder cfr_ignored_0 = (ResponseEntity.BodyBuilder)responseEntity.header(x$0, new String[]{xva$1});
        });
        return responseEntity.body(result);
    }

    @RequestMapping(path={"/multivalueheaders"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    public Map<String, Object> multiValueHeaders(ServerWebExchange exchange) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("headers", exchange.getRequest().getHeaders());
        return result;
    }

    @GetMapping(path={"/delay/{sec}/**"}, produces={"application/json"})
    public Mono<Map<String, Object>> delay(ServerWebExchange exchange, @PathVariable int sec) throws InterruptedException {
        int delay = Math.min(sec, 10);
        return Mono.just(this.get(exchange)).delayElement(Duration.ofSeconds(delay));
    }

    @GetMapping(path={"/anything/{anything}"}, produces={"application/json"})
    public Map<String, Object> anything(ServerWebExchange exchange, @PathVariable(required=false) String anything) {
        return this.get(exchange);
    }

    @GetMapping(path={"/get"}, produces={"application/json"})
    public Map<String, Object> get(ServerWebExchange exchange) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"httpbin /get");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap params = new HashMap();
        exchange.getRequest().getQueryParams().forEach((name, values) -> params.put(name, (String)values.get(0)));
        result.put("args", params);
        result.put("headers", this.getHeaders(exchange));
        return result;
    }

    @PostMapping(value={"/post"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public Mono<Map<String, Object>> postFormData(@RequestBody Mono<MultiValueMap<String, Part>> parts) {
        return parts.flux().flatMap(map -> Flux.fromIterable((Iterable)map.values())).flatMap(Flux::fromIterable).filter(part -> part instanceof FilePart).reduce(new HashMap(), (files, part) -> {
            MediaType contentType = part.headers().getContentType();
            long contentLength = part.headers().getContentLength();
            files.put(part.name(), "data:" + contentType + ";base64," + contentLength);
            return files;
        }).map(files -> Collections.singletonMap("files", files));
    }

    @PostMapping(path={"/post"}, consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    public Mono<Map<String, Object>> postUrlEncoded(ServerWebExchange exchange) throws IOException {
        return this.post(exchange, null);
    }

    @PostMapping(path={"/post"}, produces={"application/json"})
    public Mono<Map<String, Object>> post(ServerWebExchange exchange, @RequestBody(required=false) String body) throws IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("headers", this.getHeaders(exchange));
        ret.put("data", body);
        HashMap form = new HashMap();
        ret.put("form", form);
        return exchange.getFormData().flatMap(map -> {
            for (Map.Entry entry : map.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    form.put((String)entry.getKey(), value);
                }
            }
            return Mono.just((Object)ret);
        });
    }

    @GetMapping(value={"/status/{status}"})
    public ResponseEntity<String> status(@PathVariable int status) {
        return ResponseEntity.status((int)status).body((Object)("Failed with " + status));
    }

    @RequestMapping(value={"/responseheaders/{status}"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<Map<String, Object>> responseHeaders(@PathVariable int status, ServerWebExchange exchange) {
        HttpHeaders httpHeaders = exchange.getRequest().getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("X-Test-")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (list1, list2) -> Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList()), HttpHeaders::new));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)status).headers(httpHeaders)).body(Collections.singletonMap("status", status));
    }

    @PostMapping(path={"/post/empty"}, produces={"application/json"})
    public Mono<String> emptyResponse() {
        return Mono.empty();
    }

    @GetMapping(path={"/gzip"}, produces={"application/json"})
    public Mono<Void> gzip(ServerWebExchange exchange) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"httpbin /gzip");
        }
        String jsonResponse = OBJECT_MAPPER.writeValueAsString((Object)"httpbin compatible home");
        byte[] bytes = jsonResponse.getBytes(StandardCharsets.UTF_8);
        ServerHttpResponse response = exchange.getResponse();
        response.getHeaders().add("Content-Encoding", "gzip");
        DataBufferFactory dataBufferFactory = response.bufferFactory();
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream is = new GZIPOutputStream(bos);
        FileCopyUtils.copy((byte[])bytes, (OutputStream)is);
        byte[] gzippedResponse = bos.toByteArray();
        DataBuffer wrap = dataBufferFactory.wrap(gzippedResponse);
        return response.writeWith((Publisher)Flux.just((Object)wrap));
    }

    @GetMapping(value={"/vary-on-header/**"})
    public ResponseEntity<Map<String, Object>> varyOnAccept(ServerWebExchange exchange, @RequestHeader(name="X-Request-Vary", required=false) String headerToVary) {
        if (headerToVary == null) {
            return ResponseEntity.badRequest().body(Map.of("error", "X-Request-Vary header is mandatory"));
        }
        ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
        builder.varyBy(new String[]{headerToVary});
        return builder.body(this.headers(exchange));
    }

    public Map<String, String> getHeaders(ServerWebExchange exchange) {
        return exchange.getRequest().getHeaders().toSingleValueMap();
    }
}

