/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.micrometer.core.instrument.Tags;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.propagation.Propagator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.autoconfigure.actuate.observability.AutoConfigureObservability;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayMetricsFilter;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayPropagatingSenderTracingObservationHandler;
import org.springframework.cloud.gateway.filter.headers.observation.ObservationClosingWebExceptionHandler;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedRequestHttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedResponseHttpHeadersFilter;
import org.springframework.cloud.gateway.route.RouteDefinitionMetrics;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayTagsProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.web.server.ServerWebExchange;

public class GatewayMetricsAutoConfigurationTests {

    @SpringBootConfiguration
    @EnableAutoConfiguration
    protected static class CustomTagsProviderConfig {
        protected CustomTagsProviderConfig() {
        }

        @Bean
        public GatewayTagsProvider emptyTagsProvider() {
            return new EmptyTagsProvider();
        }

        protected static class EmptyTagsProvider
        implements GatewayTagsProvider {
            protected EmptyTagsProvider() {
            }

            public Tags apply(ServerWebExchange exchange) {
                return Tags.empty();
            }
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    @AutoConfigureObservability
    protected static class Config {
        protected Config() {
        }

        @Bean
        Tracer tracer() {
            return (Tracer)Mockito.mock(Tracer.class);
        }

        @Bean
        Propagator propagator() {
            return (Propagator)Mockito.mock(Propagator.class);
        }
    }

    @Nested
    @SpringBootTest(classes={CustomTagsProviderConfig.class}, properties={"spring.cloud.gateway.metrics.prefix=myprefix."})
    public class AddCustomTagsProvider {
        @Autowired(required=false)
        private GatewayMetricsFilter filter;
        @Autowired(required=false)
        private RouteDefinitionMetrics routeDefinitionMetrics;
        @Autowired(required=false)
        private List<GatewayTagsProvider> tagsProviders;

        @Test
        public void gatewayMetricsBeansExists() {
            Assertions.assertThat((Object)this.filter).isNotNull();
            Assertions.assertThat((String)this.filter.getMetricsPrefix()).isEqualTo("myprefix");
            Assertions.assertThat(this.tagsProviders).extracting("class").contains(new Object[]{CustomTagsProviderConfig.EmptyTagsProvider.class});
        }

        @Test
        public void routeDefinitionMetricsBeanExists() {
            Assertions.assertThat((Object)this.routeDefinitionMetrics).isNotNull();
            Assertions.assertThat((String)this.routeDefinitionMetrics.getMetricsPrefix()).isEqualTo("myprefix");
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.observability.enabled=false"})
    public class ObservabilityDisabledByProperty {
        @Autowired
        private BeanFactory beanFactory;

        @Test
        public void observabilityBeansMissing() {
            Assertions.assertThat((Object)((ObservedRequestHttpHeadersFilter)this.beanFactory.getBeanProvider(ObservedRequestHttpHeadersFilter.class).getIfAvailable(() -> null))).isNull();
            Assertions.assertThat((Object)((ObservedResponseHttpHeadersFilter)this.beanFactory.getBeanProvider(ObservedResponseHttpHeadersFilter.class).getIfAvailable(() -> null))).isNull();
            Assertions.assertThat((Object)((ObservationClosingWebExceptionHandler)this.beanFactory.getBeanProvider(ObservationClosingWebExceptionHandler.class).getIfAvailable(() -> null))).isNull();
            Assertions.assertThat((Object)((GatewayPropagatingSenderTracingObservationHandler)this.beanFactory.getBeanProvider(GatewayPropagatingSenderTracingObservationHandler.class).getIfAvailable(() -> null))).isNull();
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.metrics.enabled=false"})
    public class DisabledByProperty {
        @Autowired(required=false)
        private GatewayMetricsFilter filter;
        @Autowired(required=false)
        private RouteDefinitionMetrics routeDefinitionMetrics;

        @Test
        public void gatewayMetricsBeanMissing() {
            Assertions.assertThat((Object)this.filter).isNull();
        }

        @Test
        public void routeDefinitionMetricsBeanMissing() {
            Assertions.assertThat((Object)this.routeDefinitionMetrics).isNull();
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class})
    public class EnabledByDefault {
        @Autowired(required=false)
        private GatewayMetricsFilter filter;
        @Autowired(required=false)
        private RouteDefinitionMetrics routeDefinitionMetrics;
        @Autowired(required=false)
        private List<GatewayTagsProvider> tagsProviders;
        @Autowired
        private BeanFactory beanFactory;

        @Test
        public void gatewayMetricsBeansExists() {
            Assertions.assertThat((Object)this.filter).isNotNull();
            Assertions.assertThat((String)this.filter.getMetricsPrefix()).isEqualTo("spring.cloud.gateway");
            Assertions.assertThat(this.tagsProviders).isNotEmpty();
        }

        @Test
        public void routeDefinitionMetricsBeanExists() {
            Assertions.assertThat((Object)this.routeDefinitionMetrics).isNotNull();
            Assertions.assertThat((String)this.routeDefinitionMetrics.getMetricsPrefix()).isEqualTo("spring.cloud.gateway");
        }

        @Test
        public void observabilityBeansExist() {
            Assertions.assertThat((Object)((ObservedRequestHttpHeadersFilter)this.beanFactory.getBean(ObservedRequestHttpHeadersFilter.class))).isNotNull();
            Assertions.assertThat((Object)((ObservedResponseHttpHeadersFilter)this.beanFactory.getBean(ObservedResponseHttpHeadersFilter.class))).isNotNull();
            Assertions.assertThat((Object)((ObservationClosingWebExceptionHandler)this.beanFactory.getBean(ObservationClosingWebExceptionHandler.class))).isNotNull();
            Assertions.assertThat((Object)((GatewayPropagatingSenderTracingObservationHandler)this.beanFactory.getBean(GatewayPropagatingSenderTracingObservationHandler.class))).isNotNull();
        }
    }
}

