/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.cloud.test.ClassPathExclusions;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.util.TestSocketUtils;
import org.springframework.test.web.reactive.server.WebTestClient;

@ClassPathExclusions(value={"spring-cloud-loadbalancer-*.jar"})
public class GatewayNoLoadBalancerClientAutoConfigurationTests {
    private static int port;

    @BeforeAll
    public static void init() {
        port = TestSocketUtils.findAvailableTcpPort();
    }

    @Test
    public void noLoadBalancerClientReportsError() {
        try (ConfigurableApplicationContext context = new SpringApplication(new Class[]{Config.class}).run(new String[]{"--server.port=" + port, "--spring.jmx.enabled=false"});){
            WebTestClient client = WebTestClient.bindToServer().baseUrl("http://localhost:" + port).build();
            client.get().header("Host", new String[]{"www.lbfail.org"}).exchange().expectStatus().is5xxServerError();
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    @Import(value={PermitAllSecurityConfiguration.class})
    public static class Config {
        @Bean
        public RouteLocator routeLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("lb_fail", r -> r.host(new String[]{"**.lbfail.org"}).uri("lb://fail")).build();
        }
    }
}

