/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.config.conditional.OnEnabledGlobalFilter;
import org.springframework.cloud.gateway.filter.AdaptCachedBodyGlobalFilter;
import org.springframework.cloud.gateway.filter.ForwardPathFilter;
import org.springframework.cloud.gateway.filter.WebsocketRoutingFilter;

class OnEnabledGlobalFilterTests {
    private OnEnabledGlobalFilter onEnabledGlobalFilter;

    OnEnabledGlobalFilterTests() {
    }

    @BeforeEach
    void setUp() {
        this.onEnabledGlobalFilter = new OnEnabledGlobalFilter();
    }

    @Test
    void shouldNormalizeGlobalFiltersNames() {
        List<Class> predicates = Arrays.asList(ForwardPathFilter.class, AdaptCachedBodyGlobalFilter.class, WebsocketRoutingFilter.class);
        List resultNames = predicates.stream().map(arg_0 -> ((OnEnabledGlobalFilter)this.onEnabledGlobalFilter).normalizeComponentName(arg_0)).collect(Collectors.toList());
        List expectedNames = Stream.of("forward-path", "adapt-cached-body", "websocket-routing").map(s -> "global-filter." + s).collect(Collectors.toList());
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }
}

