/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.discovery;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import reactor.core.publisher.Flux;

@SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.discovery.locator.enabled=true", "spring.cloud.gateway.discovery.locator.route-id-prefix=test__"})
public class DiscoveryClientRouteDefinitionLocatorIntegrationTests {
    @Autowired
    private RouteLocator routeLocator;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private TestDiscoveryClient discoveryClient;

    @Test
    public void newServiceAddsRoute() throws Exception {
        List routes = (List)this.routeLocator.getRoutes().filter(route -> route.getId().startsWith("test__")).collectList().block();
        Assertions.assertThat((List)routes).hasSize(1);
        this.discoveryClient.multiple();
        this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)1L));
        Thread.sleep(2000L);
        routes = (List)this.routeLocator.getRoutes().filter(route -> route.getId().startsWith("test__")).collectList().block();
        Assertions.assertThat((List)routes).hasSize(2);
    }

    private static class TestDiscoveryClient
    implements ReactiveDiscoveryClient {
        AtomicBoolean single = new AtomicBoolean(true);
        DefaultServiceInstance instance1 = new DefaultServiceInstance("service1_1", "service1", "localhost", 8001, false);
        DefaultServiceInstance instance2 = new DefaultServiceInstance("service2_1", "service2", "localhost", 8001, false);

        private TestDiscoveryClient() {
        }

        public void multiple() {
            this.single.set(false);
        }

        public String description() {
            return null;
        }

        public Flux<ServiceInstance> getInstances(String serviceId) {
            if (serviceId.equals("service1")) {
                return Flux.just((Object)this.instance1);
            }
            if (serviceId.equals("service2")) {
                return Flux.just((Object)this.instance2);
            }
            return Flux.empty();
        }

        public Flux<String> getServices() {
            if (this.single.get()) {
                return Flux.just((Object)"service1");
            }
            return Flux.just((Object[])new String[]{"service1", "service2"});
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    protected static class Config {
        protected Config() {
        }

        @Bean
        TestDiscoveryClient discoveryClient() {
            return new TestDiscoveryClient();
        }
    }
}

