/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.discovery;

import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.discovery.GatewayDiscoveryClientAutoConfiguration;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

public class GatewayDiscoveryClientAutoConfigurationTest {
    private static final String SERVICE_ID = "foo";
    private static final String BASE_URI = "/foo";
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final SimpleEvaluationContext CONTEXT = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    private static final FilterDefinition DEFAULT_FILTER = (FilterDefinition)GatewayDiscoveryClientAutoConfiguration.initFilters().get(0);
    private ServiceInstance serviceInstance;

    @BeforeEach
    public void buildServiceInstance() {
        this.serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.serviceInstance.getServiceId()).thenReturn((Object)SERVICE_ID);
    }

    @Test
    public void defaultRewritePathShouldHandleEmptyRemainingWithoutSlash() {
        String expectedRemotePath = "/";
        String result = this.replace(BASE_URI);
        Assertions.assertThat((String)result).isEqualTo(expectedRemotePath);
    }

    @Test
    public void defaultRewritePathShouldHandleEmptyRemainingWithSlash() {
        String extraUri = "/";
        String result = this.replace(BASE_URI + extraUri);
        Assertions.assertThat((String)result).isEqualTo(extraUri);
    }

    @Test
    public void defaultRewritePathShouldHandleNonEmptyRemainingPath() {
        String extraUri = "/some/additional/uri";
        String result = this.replace(BASE_URI + extraUri);
        Assertions.assertThat((String)result).isEqualTo(extraUri);
    }

    private String replace(String enteringPath) {
        return enteringPath.replaceAll(this.evaluateExpression((String)DEFAULT_FILTER.getArgs().get("regexp")), this.evaluateExpression((String)DEFAULT_FILTER.getArgs().get("replacement")));
    }

    private String evaluateExpression(String expression) {
        return Objects.requireNonNull((String)PARSER.parseExpression(expression).getValue((EvaluationContext)CONTEXT, (Object)this.serviceInstance, String.class));
    }
}

