/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.ForwardRoutingFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class ForwardRoutingFilterTests {
    private ServerWebExchange exchange;
    @Mock
    private GatewayFilterChain chain;
    @Mock
    private ObjectProvider<DispatcherHandler> objectProvider;
    @Mock
    private DispatcherHandler dispatcherHandler;
    @InjectMocks
    private ForwardRoutingFilter forwardRoutingFilter;

    @BeforeEach
    public void setup() {
        this.exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)"localendpoint", (Object[])new Object[0]).build());
        Mockito.when((Object)((DispatcherHandler)this.objectProvider.getIfAvailable())).thenReturn((Object)this.dispatcherHandler);
    }

    @Test
    public void shouldNotFilterWhenGatewayRequestUrlSchemeIsNotForward() {
        URI uri = UriComponentsBuilder.fromUriString((String)"https://endpoint").build().toUri();
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
        this.forwardRoutingFilter.filter(this.exchange, this.chain);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.dispatcherHandler});
        ((GatewayFilterChain)Mockito.verify((Object)this.chain)).filter(this.exchange);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
    }

    @Test
    public void shouldFilterWhenGatewayRequestUrlSchemeIsForward() {
        URI uri = UriComponentsBuilder.fromUriString((String)"forward://endpoint").build().toUri();
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
        Assertions.assertThat(this.exchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_ALREADY_ROUTED_ATTR)).isNull();
        this.forwardRoutingFilter.filter(this.exchange, this.chain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
        ((DispatcherHandler)Mockito.verify((Object)this.dispatcherHandler)).handle((ServerWebExchange)ArgumentMatchers.assertArg(exchange -> Assertions.assertThat(exchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_ALREADY_ROUTED_ATTR)).isNull()));
    }

    @Test
    public void shouldFilterAndKeepHostPathAsSpecified() {
        URI uri = UriComponentsBuilder.fromUriString((String)"forward://host/outage").build().toUri();
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        this.forwardRoutingFilter.filter(this.exchange, this.chain);
        ((DispatcherHandler)Mockito.verify((Object)this.dispatcherHandler)).handle((ServerWebExchange)captor.capture());
        Assertions.assertThat(this.exchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_ALREADY_ROUTED_ATTR)).isNull();
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        URI forwardedUrl = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)forwardedUrl).hasScheme("forward").hasHost("host").hasPath("/outage");
    }

    @Test
    public void shouldNotFilterWhenGatewayRequestUrlSchemeIsForwardButAlreadyRouted() {
        URI uri = UriComponentsBuilder.fromUriString((String)"forward://host").build().toUri();
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ALREADY_ROUTED_ATTR, true);
        this.forwardRoutingFilter.filter(this.exchange, this.chain);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.dispatcherHandler});
        ((GatewayFilterChain)Mockito.verify((Object)this.chain)).filter(this.exchange);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
    }

    @Test
    public void orderIsLowestPrecedence() {
        Assertions.assertThat((int)this.forwardRoutingFilter.getOrder()).isEqualTo(Integer.MAX_VALUE);
    }
}

