/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeadersIfNotPresentGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(profiles={"request-headers-if-not-present-web-filter"})
public class AddRequestHeadersIfNotPresentGatewayFilterFactoryTests
extends BaseWebClientTests {
    private static final String TEST_HEADER_1 = "X-Request-Example";
    private static final String TEST_HEADER_2 = "X-Request-Second-Example";
    private static final String TEST_HOST_HEADER_VALUE = "www.addrequestheaderjava.org";

    @Test
    public void addRequestHeadersIfHeaderPresentFilterDoesNotAddHeaderIfPresent() {
        String initialHeaderValue = "initial-value";
        this.testClient.get().uri("/headers", new Object[0]).header(TEST_HEADER_1, new String[]{"initial-value"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)TEST_HEADER_1, (Object)"initial-value");
        });
    }

    @Test
    public void addRequestHeadersIfNotPresentFilterWorks() {
        this.testClient.get().uri("/headers", new Object[0]).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)TEST_HEADER_1, (Object)"ValueA");
        });
    }

    @Test
    public void addRequestHeadersIfNotPresentFilterOnlyWorksFirstPassWhenMultipleValues() {
        this.testClient.get().uri("/multivalueheaders", new Object[0]).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)TEST_HEADER_1, Arrays.asList("ValueA"));
            Assertions.assertThat(headers).containsEntry((Object)TEST_HEADER_2, Arrays.asList("ValueC"));
        });
    }

    @Test
    public void addRequestHeadersIfNotPresentFilterWorksOnlyMissingValues() {
        String existingValue = "existing-value";
        this.testClient.get().uri("/multivalueheaders", new Object[0]).header(TEST_HEADER_2, new String[]{"existing-value"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)TEST_HEADER_1, Arrays.asList("ValueA"));
            Assertions.assertThat(headers).containsEntry((Object)TEST_HEADER_2, Arrays.asList("existing-value"));
        });
    }

    @Test
    public void addRequestHeadersIfNotPresentFilterWorksJavaDsl() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{TEST_HOST_HEADER_VALUE}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"X-Request-Acme", (Object)"ValueB-www");
        });
    }

    @Test
    public void addRequestHeadersIfNotPresentFilterMultipleValuesWorksJavaDsl() {
        this.testClient.get().uri("/multivalueheaders", new Object[0]).header("Host", new String[]{TEST_HOST_HEADER_VALUE}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"X-Request-Acme", Arrays.asList("ValueX", "ValueY", "ValueZ", "www"));
        });
    }

    @Test
    public void toStringFormat() {
        AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValueConfig keyValueConfig = new AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValueConfig();
        keyValueConfig.setKeyValues(new AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue[]{new AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue("my-header-name-1", "my-header-value-1"), new AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue("my-header-name-2", "my-header-value-2")});
        GatewayFilter filter = new AddRequestHeadersIfNotPresentGatewayFilterFactory().apply(keyValueConfig);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).startsWith((CharSequence)"[AddRequestHeadersIfNotPresent")).contains(new CharSequence[]{"my-header-name-1 = 'my-header-value-1'"})).contains(new CharSequence[]{"my-header-name-2 = 'my-header-value-2'"})).endsWith((CharSequence)"]");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("add_request_headers_if_not_present_java_test", r -> r.path(new String[]{"/headers"}).and().host(new String[]{"{sub}.addrequestheaderjava.org"}).filters(f -> f.addRequestHeadersIfNotPresent(new String[]{"X-Request-Acme:ValueB-{sub}"})).uri(this.uri)).route("add_multiple_request_headers_java_test", r -> r.path(new String[]{"/multivalueheaders"}).and().host(new String[]{"{sub}.addrequestheaderjava.org"}).filters(f -> f.addRequestHeadersIfNotPresent(new String[]{"X-Request-Acme:ValueX", "X-Request-Acme:ValueY", "X-Request-Acme:ValueZ", "X-Request-Acme:{sub}"})).uri(this.uri)).build();
        }
    }
}

