/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.PrefixPathGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class PrefixPathGatewayFilterFactoryTest {
    @Test
    public void testPrefixPath() {
        this.testPrefixPathFilter("/foo", "/bar", "/foo/bar");
        this.testPrefixPathFilter("/foo", "/hello%20world", "/foo/hello%20world");
    }

    @Test
    public void testPrefixPathWithVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", "foo");
        this.testPrefixPathFilter("/{id}", "/bar", "/foo/bar", variables);
    }

    @Test
    public void testPrefixPathWithMultipleVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", "foo");
        variables.put("hello", "world");
        variables.put("product", "bar");
        this.testPrefixPathFilter("/{id}/v1/{hello}/{product}", "/test", "/foo/v1/world/bar/test", variables);
    }

    private void testPrefixPathFilter(String prefix, String path, String expectedPath) {
        this.testPrefixPathFilter(prefix, path, expectedPath, new HashMap<String, String>());
    }

    private void testPrefixPathFilter(String prefix, String path, String expectedPath, HashMap<String, String> variables) {
        GatewayFilter filter = new PrefixPathGatewayFilterFactory().apply(c -> c.setPrefix(prefix));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)("http://localhost" + path), (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        ServerWebExchangeUtils.putUriTemplateVariables((ServerWebExchange)exchange, variables);
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        filter.filter((ServerWebExchange)exchange, filterChain);
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        Assertions.assertThat((URI)webExchange.getRequest().getURI()).hasPath(expectedPath);
        LinkedHashSet uris = (LinkedHashSet)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        Assertions.assertThat((Collection)uris).contains((Object[])new URI[]{request.getURI()});
    }

    @Test
    public void toStringFormat() {
        PrefixPathGatewayFilterFactory.Config config = new PrefixPathGatewayFilterFactory.Config();
        config.setPrefix("myprefix");
        GatewayFilter filter = new PrefixPathGatewayFilterFactory().apply(config);
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myprefix"});
    }
}

