/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersProperties;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SecureHeadersGatewayFilterFactoryUnitTests {
    private GatewayFilter filter;
    private ServerWebExchange exchange;
    private GatewayFilterChain filterChain;
    private ArgumentCaptor<ServerWebExchange> captor;

    @BeforeEach
    public void setUp() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).build();
        this.exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        this.filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        this.captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)this.filterChain.filter((ServerWebExchange)this.captor.capture())).thenReturn((Object)Mono.empty());
    }

    @Test
    public void addAllHeadersIfNothingIsDisabled() {
        SecureHeadersGatewayFilterFactory filterFactory = new SecureHeadersGatewayFilterFactory(new SecureHeadersProperties());
        this.filter = filterFactory.apply(new SecureHeadersGatewayFilterFactory.Config());
        this.filter.filter(this.exchange, this.filterChain).block();
        ServerHttpResponse response = this.exchange.getResponse();
        Assertions.assertThat((Map)response.getHeaders()).containsKeys((Object[])new String[]{"X-Xss-Protection", "Strict-Transport-Security", "X-Frame-Options", "X-Content-Type-Options", "Referrer-Policy", "Content-Security-Policy", "X-Download-Options", "X-Permitted-Cross-Domain-Policies"});
    }

    @Test
    public void doNotAddDisabledHeaders() {
        SecureHeadersProperties properties = new SecureHeadersProperties();
        properties.setDisable(Arrays.asList("x-xss-protection", "strict-transport-security", "x-frame-options", "x-content-type-options", "referrer-policy", "content-security-policy", "x-download-options", "x-permitted-cross-domain-policies"));
        SecureHeadersGatewayFilterFactory filterFactory = new SecureHeadersGatewayFilterFactory(properties);
        this.filter = filterFactory.apply(new SecureHeadersGatewayFilterFactory.Config());
        this.filter.filter(this.exchange, this.filterChain).block();
        ServerHttpResponse response = ((ServerWebExchange)this.captor.getValue()).getResponse();
        Assertions.assertThat((Map)response.getHeaders()).doesNotContainKeys((Object[])new String[]{"X-Xss-Protection", "Strict-Transport-Security", "X-Frame-Options", "X-Content-Type-Options", "Referrer-Policy", "Content-Security-Policy", "X-Download-Options", "X-Permitted-Cross-Domain-Policies"});
    }

    @Test
    public void overrideSomeHeaders() {
        SecureHeadersProperties properties = new SecureHeadersProperties();
        SecureHeadersGatewayFilterFactory filterFactory = new SecureHeadersGatewayFilterFactory(new SecureHeadersProperties());
        SecureHeadersGatewayFilterFactory.Config config = new SecureHeadersGatewayFilterFactory.Config();
        config.setStrictTransportSecurity("max-age=65535");
        config.setReferrerPolicy("referrer");
        this.filter = filterFactory.apply(config);
        this.filter.filter(this.exchange, this.filterChain).block();
        ServerHttpResponse response = this.exchange.getResponse();
        Assertions.assertThat((Map)response.getHeaders()).containsKeys((Object[])new String[]{"X-Xss-Protection", "Strict-Transport-Security", "X-Frame-Options", "X-Content-Type-Options", "Referrer-Policy", "Content-Security-Policy", "X-Download-Options", "X-Permitted-Cross-Domain-Policies"});
        Assertions.assertThat((List)response.getHeaders().get((Object)"Strict-Transport-Security")).containsOnly((Object[])new String[]{"max-age=65535"});
        Assertions.assertThat((List)response.getHeaders().get((Object)"Referrer-Policy")).containsOnly((Object[])new String[]{"referrer"});
        Assertions.assertThat((List)response.getHeaders().get((Object)"X-Xss-Protection")).containsOnly((Object[])new String[]{properties.getXssProtectionHeader()});
        Assertions.assertThat((List)response.getHeaders().get((Object)"X-Frame-Options")).containsOnly((Object[])new String[]{properties.getFrameOptions()});
        Assertions.assertThat((List)response.getHeaders().get((Object)"X-Content-Type-Options")).containsOnly((Object[])new String[]{properties.getContentTypeOptions()});
        Assertions.assertThat((List)response.getHeaders().get((Object)"Content-Security-Policy")).containsOnly((Object[])new String[]{properties.getContentSecurityPolicy()});
        Assertions.assertThat((List)response.getHeaders().get((Object)"X-Download-Options")).containsOnly((Object[])new String[]{properties.getDownloadOptions()});
        Assertions.assertThat((List)response.getHeaders().get((Object)"X-Permitted-Cross-Domain-Policies")).containsOnly((Object[])new String[]{properties.getPermittedCrossDomainPolicies()});
    }

    @Test
    public void doesNotDuplicateHeaders() {
        String[] headers;
        String originalHeaderValue = "original-header-value";
        SecureHeadersGatewayFilterFactory filterFactory = new SecureHeadersGatewayFilterFactory(new SecureHeadersProperties());
        SecureHeadersGatewayFilterFactory.Config config = new SecureHeadersGatewayFilterFactory.Config();
        for (String header : headers = new String[]{"X-Xss-Protection", "Strict-Transport-Security", "X-Frame-Options", "X-Content-Type-Options", "Referrer-Policy", "Content-Security-Policy", "X-Download-Options", "X-Permitted-Cross-Domain-Policies"}) {
            this.filter = filterFactory.apply(config);
            MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).build();
            this.exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
            this.exchange.getResponse().getHeaders().set(header, originalHeaderValue);
            this.filter.filter(this.exchange, this.filterChain).block();
            ServerHttpResponse response = ((ServerWebExchange)this.captor.getValue()).getResponse();
            Assertions.assertThat((List)response.getHeaders().get((Object)header)).containsOnly((Object[])new String[]{originalHeaderValue});
        }
    }

    @Test
    public void toStringFormat() {
        GatewayFilter filter = new SecureHeadersGatewayFilterFactory(new SecureHeadersProperties()).apply(new SecureHeadersGatewayFilterFactory.Config());
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"SecureHeaders"});
    }
}

