/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class SetResponseHeaderGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void setResponseHeaderFilterWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.setreresponseheader.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Response-Foo", new String[]{"Bar"});
    }

    @Test
    public void setResponseHeaderFilterWorksJavaDsl() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.setresponseheaderdsl.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Res-Foo", new String[]{"Second-www"});
    }

    @Test
    public void toStringFormat() {
        AbstractNameValueGatewayFilterFactory.NameValueConfig config = new AbstractNameValueGatewayFilterFactory.NameValueConfig().setName("myname").setValue("myvalue");
        GatewayFilter filter = new SetResponseHeaderGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"})).contains(new CharSequence[]{"myvalue"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_set_response_header_dsl", r -> r.order(-1).host(new String[]{"{sub}.setresponseheaderdsl.org"}).filters(f -> f.prefixPath("/httpbin").setResponseHeader("X-Res-Foo", "Second-{sub}").addResponseHeader("X-Res-Foo", "First")).uri(this.uri)).build();
        }
    }
}

